<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=EDGE" />
  <meta name="viewport" content="width=device-width,initial-scale=1">

  <!-- Chrome, Firefox OS and Opera -->
  <meta name="theme-color" content="#75C7C3">
  <!-- Windows Phone -->
  <meta name="msapplication-navbutton-color" content="#75C7C3">
  <!-- iOS Safari -->
  <meta name="apple-mobile-web-app-status-bar-style" content="#75C7C3">

  <title><?php echo e(trans('laravel-filemanager::lfm.title-page')); ?></title>
  <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('vendor/laravel-filemanager/img/folder.png')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('vendor/laravel-filemanager/css/lib/bootstrap.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('vendor/laravel-filemanager/css/lib/font-awesome.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('vendor/laravel-filemanager/css/cropper.min.css')); ?>">
  <style><?php echo \File::get(base_path('vendor/unisharp/laravel-filemanager/public/css/lfm.css')); ?></style>
  
  
  <link rel="stylesheet" href="<?php echo e(asset('vendor/laravel-filemanager/css/mfb.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('vendor/laravel-filemanager/css/lib/jquery-ui.min.css')); ?>">
</head>
<body>
  <div class="container-fluid" id="wrapper">
    <div class="panel panel-primary hidden-xs">
      <div class="panel-heading">
        <h1 class="panel-title"><?php echo e(trans('laravel-filemanager::lfm.title-panel')); ?></h1>
      </div>
    </div>
    <div class="row">
      <div class="col-sm-2 hidden-xs">
        <div id="tree"></div>
      </div>

      <div class="col-sm-10 col-xs-12" id="main">
        <nav class="navbar navbar-default" id="nav">
          <div class="navbar-header">
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#nav-buttons">
              <span class="sr-only">Toggle navigation</span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
            </button>
            <a class="navbar-brand clickable hide" id="to-previous">
              <i class="fa fa-arrow-left"></i>
              <span class="hidden-xs"><?php echo e(trans('laravel-filemanager::lfm.nav-back')); ?></span>
            </a>
            <a class="navbar-brand visible-xs" href="#"><?php echo e(trans('laravel-filemanager::lfm.title-panel')); ?></a>
          </div>
          <div class="collapse navbar-collapse" id="nav-buttons">
            <ul class="nav navbar-nav navbar-right">
              <li>
                <a class="clickable" id="thumbnail-display">
                  <i class="fa fa-th-large"></i>
                  <span><?php echo e(trans('laravel-filemanager::lfm.nav-thumbnails')); ?></span>
                </a>
              </li>
              <li>
                <a class="clickable" id="list-display">
                  <i class="fa fa-list"></i>
                  <span><?php echo e(trans('laravel-filemanager::lfm.nav-list')); ?></span>
                </a>
              </li>
              <li class="dropdown">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                  <?php echo e(trans('laravel-filemanager::lfm.nav-sort')); ?> <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                  <li>
                    <a href="#" id="list-sort-alphabetic">
                      <i class="fa fa-sort-alpha-asc"></i> <?php echo e(trans('laravel-filemanager::lfm.nav-sort-alphabetic')); ?>

                    </a>
                  </li>
                  <li>
                    <a href="#" id="list-sort-time">
                      <i class="fa fa-sort-amount-asc"></i> <?php echo e(trans('laravel-filemanager::lfm.nav-sort-time')); ?>

                    </a>
                  </li>
                </ul>
              </li>
            </ul>
          </div>
        </nav>
        <div class="visible-xs" id="current_dir" style="padding: 5px 15px;background-color: #f8f8f8;color: #5e5e5e;"></div>

        <div id="alerts"></div>

        <div id="content"></div>
      </div>

      <ul id="fab">
        <li>
          <a href="#"></a>
          <ul class="hide">
            <li>
              <a href="#" id="add-folder" data-mfb-label="<?php echo e(trans('laravel-filemanager::lfm.nav-new')); ?>">
                <i class="fa fa-folder"></i>
              </a>
            </li>
            <li>
              <a href="#" id="upload" data-mfb-label="<?php echo e(trans('laravel-filemanager::lfm.nav-upload')); ?>">
                <i class="fa fa-upload"></i>
              </a>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>

  <div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aia-hidden="true">&times;</span></button>
          <h4 class="modal-title" id="myModalLabel"><?php echo e(trans('laravel-filemanager::lfm.title-upload')); ?></h4>
        </div>
        <div class="modal-body">
          <form action="<?php echo e(route('unisharp.lfm.upload')); ?>" role='form' id='uploadForm' name='uploadForm' method='post' enctype='multipart/form-data'>
            <div class="form-group" id="attachment">
              <label for='upload' class='control-label'><?php echo e(trans('laravel-filemanager::lfm.message-choose')); ?></label>
              <div class="controls">
                <div class="input-group" style="width: 100%">
                  <input type="file" id="upload" name="upload[]" multiple="multiple">
                </div>
              </div>
            </div>
            <input type='hidden' name='working_dir' id='working_dir'>
            <input type='hidden' name='type' id='type' value='<?php echo e(request("type")); ?>'>
            <input type='hidden' name='_token' value='<?php echo e(csrf_token()); ?>'>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('laravel-filemanager::lfm.btn-close')); ?></button>
          <button type="button" class="btn btn-primary" id="upload-btn"><?php echo e(trans('laravel-filemanager::lfm.btn-upload')); ?></button>
        </div>
      </div>
    </div>
  </div>


  <script src="<?php echo e(asset('vendor/laravel-filemanager/js/lib/jquery.min.js')); ?>"></script>

  <script src="<?php echo e(asset('vendor/laravel-filemanager/js/lib/bootstrap.min.js')); ?>"></script>

  <script src="<?php echo e(asset('vendor/laravel-filemanager/js/lib/bootbox.min.js')); ?>"></script>

  <script src="<?php echo e(asset('vendor/laravel-filemanager/js/lib/jquery-ui.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendor/laravel-filemanager/js/cropper.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendor/laravel-filemanager/js/jquery.form.min.js')); ?>"></script>
  <script>
    var route_prefix = "<?php echo e(url('/')); ?>";
    var lfm_route = "<?php echo e(url(config('lfm.prefix'))); ?>";
    var lang = <?php echo json_encode(trans('laravel-filemanager::lfm')); ?>;
  </script>
  <script><?php echo \File::get(base_path('vendor/unisharp/laravel-filemanager/public/js/script.js')); ?></script>
  
  
  <script>
    $.fn.fab = function () {
      var menu = this;
      menu.addClass('mfb-component--br mfb-zoomin').attr('data-mfb-toggle', 'hover');
      var wrapper = menu.children('li');
      wrapper.addClass('mfb-component__wrap');
      var parent_button = wrapper.children('a');
      parent_button.addClass('mfb-component__button--main')
        .append($('<i>').addClass('mfb-component__main-icon--resting fa fa-plus'))
        .append($('<i>').addClass('mfb-component__main-icon--active fa fa-times'));
      var children_list = wrapper.children('ul');
      children_list.find('a').addClass('mfb-component__button--child');
      children_list.find('i').addClass('mfb-component__child-icon');
      children_list.addClass('mfb-component__list').removeClass('hide');
    };
    $('#fab').fab({
      buttons: [
        {
          icon: 'fa fa-folder',
          label: "<?php echo e(trans('laravel-filemanager::lfm.nav-new')); ?>",
          attrs: {id: 'add-folder'}
        },
        {
          icon: 'fa fa-upload',
          label: "<?php echo e(trans('laravel-filemanager::lfm.nav-upload')); ?>",
          attrs: {id: 'upload'}
        }
      ]
    });
  </script>
</body>
</html>
<?php /**PATH C:\wamp\www\t-connect\resources\views/vendor/laravel-filemanager/index.blade.php ENDPATH**/ ?>