<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($reservation ?? ''  && $reservation->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="form-group col-lg-4">
                <label><?php echo e(meta('name', $lang) ?? __('reservations.name')); ?> </label>
                <input  readonly class="form-control bg-white" value='<?php echo e($reservation->name); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('phone', $lang) ?? __('reservations.phone')); ?> </label>
                <input  readonly class="form-control bg-white" value='<?php echo e($reservation->phone); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('email', $lang) ?? __('reservations.email')); ?> </label>
                <input  readonly class="form-control bg-white" value='<?php echo e($reservation->email); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('service_id', $lang) ?? __('reservations.service_id')); ?> </label>
                <input  readonly class="form-control bg-white" value='<?php echo e($reservation->service_name); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('durations', $lang) ?? __('reservations.durations')); ?> </label>
                <input  readonly class="form-control bg-white"  value='<?php echo e($reservation->durations); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('branch_id', $lang) ?? __('reservations.branch_id')); ?> </label>
                <input  readonly class="form-control bg-white"  value='<?php echo e($reservation->branch_name); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('doctor_id', $lang) ?? __('reservations.doctor_id')); ?> </label>
                <input  readonly class="form-control bg-white" name="doctor_name" value='<?php echo e($reservation->doctor_name); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('appointment_date', $lang) ?? __('reservations.appointment_date')); ?> </label>
                <input  readonly class="form-control bg-white"  value='<?php echo e($reservation->appointment_date); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('appointment_time', $lang) ?? __('reservations.appointment_time')); ?> </label>
                <input  readonly class="form-control bg-white"  value='<?php echo e($reservation->appointment_time); ?>'/>
            </div>

            <?php if($reservation->status == 'confirmed'): ?>
                <div class="form-group col-lg-6">
                    <label><?php echo e(meta('status', $lang) ?? __('appointments.status')); ?> </label>
                    <select name="status" class="form-control <?php echo e($errors->has('status') ? 'is-invalid' : ''); ?>">
                        <option <?php echo e($reservation->status == 'confirmed' ? 'selected' : ''); ?> value="confirmed"><?php echo e(__('reservations.confirmed')); ?></option>
                    </select>
                </div>
                <?php else: ?>
                <div class="form-group col-lg-6">
                    <label><?php echo e(meta('status', $lang) ?? __('appointments.status')); ?> </label>
                    <select name="status" class="form-control <?php echo e($errors->has('status') ? 'is-invalid' : ''); ?>">
                        <option value=""><?php echo e(meta('status', $lang) ?? __('appointments.status')); ?></option>
                        <option <?php echo e($reservation->status == 'confirmed' ? 'selected' : ''); ?> value="confirmed"><?php echo e(__('reservations.confirmed')); ?></option>
                        <option <?php echo e($reservation->status == 'un_confirmed' ? 'selected' : ''); ?> value="un_confirmed"><?php echo e(__('reservations.un_confirmed')); ?></option>
                    </select>
                </div>
            <?php endif; ?>
            <?php if(is_null($reservation->updated_calendar)): ?>
            <div class="form-group col-lg-12 mt-3">
                <a href="<?php echo e(url('admin/reservations/'.$reservation->id)); ?>" class="butn primary_butn m-auto mt-5"><?php echo e(__('reservations.add_appointment_to_calender')); ?></a>
            </div>
            <?php endif; ?>

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<!-- Success Modal -->
<?php if(session('added_to_calender')): ?>
    <div class="modal stateModal fade successModal" id="confirmModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <button type="button" class="butn_close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fa-solid fa-xmark"></i>
                </button>
                <div class="modal-body text-center">
                    <img style="width: 400px" src="<?php echo e(asset('assets/web/images/modals/confirm.png')); ?>" alt="" class="img"/>
                    <h3 class="title color-primary  text-center"><b><?php echo e(__('reservations.added_to_calender_msg')); ?></b></h3>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <script>
        sendAjax('.add_button', '.add_form');

        $(document).ready(function () {
            let addedToCalender = "<?php echo e(session('added_to_calender')); ?>";
            if(addedToCalender){
                $('.successModal').modal('show');
                "<?php echo e(session()->forget('added_to_calender')); ?>";
            }
        });

    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/reservations/form.blade.php ENDPATH**/ ?>