<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_reply_form" method="post" action="<?php echo e($action); ?>">
        <?php if($visitorMessage ?? ''  && $visitorMessage->id ?? ''): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <?php if($visitorMessage ?? ''): ?>
        <div class="form-group col-lg-4">
            <label><?php echo e(meta('name', $lang) ?? __('visitorMessages.name')); ?> </label>
            <p class="form-control" style="height: auto"><?php echo e($visitorMessage->name); ?></p>
        </div>
        <div class="form-group col-lg-4">
            <label><?php echo e(meta('visitor_email', $lang) ?? __('visitorMessages.email')); ?> </label>
            <p class="form-control" style="height: auto"><?php echo e($visitorMessage->email); ?></p>
        </div>
        <div class="form-group col-lg-4">
            <label><?php echo e(meta('phone', $lang) ?? __('visitorMessages.phone')); ?> </label>
            <p class="form-control" style="height: auto"><?php echo e($visitorMessage->phone); ?></p>
        </div>




        <div class="form-group col-lg-12">
            <label><?php echo e(meta('message', $lang) ?? __('visitorMessages.message')); ?></label>
            <p class="form-control overflow-auto" style="height: 200px;"><?php echo e($visitorMessage->message); ?></p>
        </div>
        <?php endif; ?>
        
        <?php if($replies ?? false): ?>

            <?php $__currentLoopData = $replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-1">
                        <div class="thumbnail">
                            <img class="img-responsive rounded img-thumbnail user_photo" src="<?php echo e(getUser($reply->user_id)->photo ? asset(getUser($reply->user_id)->photo) : asset('assets/admin/images/reply_avatar.png')); ?>">
                        </div>
                    </div>
                    <div class="card col-sm-11 reply_card mb-2">
                        <div class="card-header d-flex justify-content-between">
                            <strong><?php echo e(getUser($reply->user_id)->name); ?></strong> <span class="bg-dark text-white rounded px-1"><i class="fa fa-user-clock"></i> <?php echo e($reply->created_at); ?></span>
                        </div>
                        <div class="card-body">
                            <?php echo $reply->reply; ?>

                        </div>
                    </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php endif; ?>
        

            <div class="card col-md-12 mt-3">
                <div class="card-header">
                    <div class="card-title">
                        <h4><?php echo e(meta('reply', $lang) ?? 'Replying on message'); ?></h4>
                    </div>
                </div>

                <div class="card-body">
                    <div class="form-group col-lg-12">
                        <label><?php echo e(meta('send_to', $lang) ?? __('visitorMessages.send_to')); ?> </label>
                        <input type="text" name="visitor_email" class="form-control <?php echo e($errors->has('visitor_email') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('visitorMessages.email')); ?>" value="<?php echo e(old("email", $visitorMessage->email ?? "")); ?>">
                    </div>
                    <div class="form-group col-lg-12">
                        <label><?php echo e(meta('message', $lang) ??  __('visitorMessages.message')); ?> </label>
                        <textarea name="reply" class="form-control my-editor" placeholder="<?php echo e(__('visitorMessages.message')); ?>"><?php echo e(old("message")); ?></textarea>
                    </div>
                </div>
            </div>

        <div class="text-center mt-5 col-12">
            <button class="butn add_reply_button"><span><?php echo e(__('dashboard.send')); ?></span></button>
        </div>

    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>

    <script>
        var route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>";
        var url = "<?php echo e(url('/')); ?>/";
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_reply_button', '.add_reply_form')
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/visitor_messages/form.blade.php ENDPATH**/ ?>