<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="<?php echo e(auth()->id()); ?>">
        <?php if($siteSlider ?? ''  && $siteSlider->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('button_url', $lang) ?? __('siteSliders.button_url')); ?> </label>
            <input type="url" class="form-control <?php echo e($errors->has('button_url') ? 'is-invalid' : ''); ?>" name="button_url" placeholder="<?php echo e(meta('button_url', $lang) ?? __('siteSliders.button_url')); ?>" value='<?php echo e(old("button_url", $siteSlider->button_url ?? "")); ?>'/>
        </div>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('title', $language->local) ?? __('siteSliders.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('siteSliders.title')); ?>" value='<?php echo e(old("title_{$language->local}", $siteSlider[$language->local]->title ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('button_title', $language->local) ?? __('siteSliders.button_title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('button_title_'.$language->local) ? 'is-invalid' : ''); ?>" name="button_title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('button_title', $language->local) ?? __('siteSliders.button_title')); ?>" value='<?php echo e(old("button_title_{$language->local}", $siteSlider[$language->local]->button_title ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('description', $language->local) ?? __('siteSliders.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <textarea rows="5" name="description_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('siteSliders.description')); ?>"><?php echo e(old("description_{$language->local}", $siteSlider[$language->local]->description ?? "")); ?></textarea>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('image', getCurrentLocale()) ?? __('siteSliders.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $siteSlider->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $siteSlider->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $siteSlider->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $siteSlider->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
        let imgSrc = "<?php echo e(asset('assets/admin/images/file-icon.png')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/site_sliders/form.blade.php ENDPATH**/ ?>