<?php $__env->startSection('content'); ?>
    <!-- ------------ charts ------------- -->
    <div class="charts_container">
        <div class="row">
            
            <div class="col-lg-12">
                <div class="chart_box">
                    <div class="chart_head mb-4">
                        <div class="row">
                            <div class="col-lg-12 d-flex justify-content-<?php echo e(getCurrentLocale() == 'ar' ? 'start' : 'end'); ?>">
                                <h5> <?php echo e(__('dashboard.visits_in')); ?> </h5>
                            </div>
                            <div class="col-lg-12 d-flex align-items-center">
                                <a data-axis="<?php echo e($yearsAxis); ?>" data-data="<?php echo e($yearsData); ?>" data-color="#27a444" class="btn last_7_years visits_chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-success"></i> <p><?php echo e(__('dashboard.last_7_years')); ?> </p></a>
                                <a data-axis="<?php echo e($monthsAxis); ?>" data-data="<?php echo e($monthsData); ?>" data-color="#3abad6" class="btn last_7_months visits_chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-primary"></i> <p><?php echo e(__('dashboard.last_7_months')); ?> </p></a>
                                <a data-axis="[]" data-data="<?php echo e($weeksData); ?>" data-color="#ffc107" class="btn last_7_weeks visits_chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-warning"></i> <p><?php echo e(__('dashboard.last_7_weeks')); ?></p></a>
                                <a class="all_visits_chart d-flex align-items-center mr-5" href="#0"><i class="fa fa-circle text-secondary"></i> <p><?php echo e(__('dashboard.all_chart')); ?></p></a>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-12 d-flex justify-content-<?php echo e(getCurrentLocale() == 'ar' ? 'start' : 'end'); ?>">
                                <h5> <?php echo e(__('dashboard.reservations_in')); ?> </h5>
                            </div>
                            <div class="col-lg-12 d-flex align-items-center">
                                <a data-axis="<?php echo e($reservationsYearsAxis); ?>" data-data="<?php echo e($reservationsYearsData); ?>" data-color="#27a444" class="btn last_7_years reservations_chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-success"></i> <p><?php echo e(__('dashboard.last_7_years')); ?> </p></a>
                                <a data-axis="<?php echo e($reservationsMonthsAxis); ?>" data-data="<?php echo e($reservationsMonthsData); ?>" data-color="#3abad6" class="btn last_7_months reservations_chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-primary"></i> <p><?php echo e(__('dashboard.last_7_months')); ?> </p></a>
                                <a data-axis="[]" data-data="<?php echo e($reservationsWeeksData); ?>" data-color="#ffc107" class="btn last_7_weeks reservations_chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-warning"></i> <p><?php echo e(__('dashboard.last_7_weeks')); ?></p></a>
                                <a class="all_reservations_chart d-flex align-items-center mr-5" href="#0"><i class="fa fa-circle text-secondary"></i> <p><?php echo e(__('dashboard.all_chart')); ?></p></a>
                            </div>
                        </div>
                    </div>
                    <div id="line_chart"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- ------------ general-report ------------- -->
    <section class="general-report mt-5 shadow">
        <div class="row">
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-info m-0">
                            <i class="bi bi-people-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('dashboard.visit_in_year')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisYearVisitors); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-info m-0">
                            <i class="bi bi-people-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('dashboard.visit_in_month')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisMonthVisitors); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-info m-0">
                            <i class="bi bi-people-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('dashboard.visit_in_week')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisWeekVisitors); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-info m-0">
                            <i class="bi bi-people-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('dashboard.visit_in_day')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisDayVisitors); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="general-report mt-5 shadow">
        <div class="row">
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-warning m-0">
                            <i class="bi bi-cart-check-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('reservations.annual_reservations')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisYearReservations); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-warning m-0">
                            <i class="bi bi-cart-check-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('reservations.monthly_reservations')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisMonthReservations); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-warning m-0">
                            <i class="bi bi-cart-check-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('reservations.weekly_reservations')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisWeekReservations); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="items">
                    <div class="top mb-3">
                        <span class="icon alert alert-warning m-0">
                            <i class="bi bi-cart-check-fill"></i>
                        </span>
                    </div>
                    <div class="bottom">
                        <div>
                            <p><?php echo e(__('reservations.daily_reservations')); ?></p>
                            <h2 class="counter mb-0 mt-1 fnt_rpt"><?php echo e($thisDayReservations); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('reservations.name')); ?></th>
                    <th><?php echo e(__('reservations.service_reservations_counts')); ?></th>
                </tr>
                </thead>
                <tbody>

                <?php if(count($mostCommonServices)): ?>
                    <?php $__currentLoopData = $mostCommonServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mostCommonService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($mostCommonService[0]['name']); ?></td>
                            <td><?php echo e(count($mostCommonService)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <tr>
                        <th colspan="3" class="text-center text-danger"><?php echo e(__('reservations.no_data_to_show')); ?></th>
                    </tr>
                <?php endif; ?>

                </tbody>
            </table>
        </div>
    </section>

    <!-- -------------- tables ----------------- -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

<!--------- new scripts ----------->

<script src="<?php echo e(asset('assets/admin/js/lib/Chart.min.js')); ?>"></script>
<!-- ------- apex chart -------------- -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<!-- ------- data table  -------------- -->
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.23/js/dataTables.bootstrap4.min.js"></script>
<!-- ----------- datepicker ----------- -->
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<!-- ---------- charts ---------- -->

    <script>

        let yearContainer = $('.last_7_years'),
            monthContainer = $('.last_7_months'),
            weekContainer = $('.last_7_weeks'),

            reservationYearContainer = $('.last_7_years.reservations_chart_links'),
            reservationMonthContainer = $('.last_7_months.reservations_chart_links'),
            reservationWeekContainer = $('.last_7_weeks.reservations_chart_links');

        let yearData = yearContainer.data('data'),
            yearAxis = yearContainer.data('axis'),

            reservationYearData = reservationYearContainer.data('data'),
            reservationYearAxis = reservationYearContainer.data('axis'),

            monthData = monthContainer.data('data'),
            monthAxis = weekContainer.data('axis'),

            reservationMonthData = reservationMonthContainer.data('data'),
            reservationMonthAxis = reservationMonthContainer.data('axis'),

            weekData = weekContainer.data('data'),
            weekAxis = weekContainer.data('axis'),

            reservationWeekData = reservationWeekContainer.data('data'),
            reservationWeekAxis = reservationWeekContainer.data('axis'),

            yearName = yearContainer.children('p').html(),
            monthName = monthContainer.children('p').html(),
            weekName = weekContainer.children('p').html(),

            reservationYearName = reservationYearContainer.children('p').html(),
            reservationMonthName = reservationMonthContainer.children('p').html(),
            reservationWeekName = reservationWeekContainer.children('p').html();


        let line_visits_chart_options = {
            series: [
                {name: yearName, data: yearData},
                {name: monthName, data: monthData},
                {name: weekName, data: weekData},
            ],
            colors: ['#27a444', '#3abad6', '#ffc107'],
            chart: {
                height: 350,
                type: 'area',
                // events:{
                //     legendClick: function (chartContext, seriesIndex, config) {
                //         if(seriesIndex === 0){
                //             chart.updateOptions({
                //                 xaxis: {
                //                     categories: yearAxis,
                //                 },
                //             });
                //         }
                //         if(seriesIndex === 1){
                //             chart.updateOptions({
                //                 xaxis: {
                //                     categories: monthAxis,
                //                 },
                //             });
                //         }
                //         if(seriesIndex === 2){
                //             chart.updateOptions({
                //                 xaxis: {
                //                     categories: weekAxis,
                //                 },
                //             });
                //         }
                //     }
                // }

            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                curve: 'smooth'
            },
            xaxis: {
                categories: yearAxis,
            },
            legend: {
                show: false,
                // position: 'top',
                // horizontalAlign: 'right',
                // offsetX: -10
            },
            tooltip: {
                x: {
                    format: 'dd/MM/yy HH:mm',
                },
            },
        };

        let chartSelector = document.querySelector("#line_chart");
        let chart = new ApexCharts(chartSelector, line_visits_chart_options);

        chart.render();


        $('.all_visits_chart').click(function (e) {
            e.preventDefault();
            $('.visits_chart_links').removeClass('disabled');
            $('#line_chart').html('');
            let chartSelector = document.querySelector("#line_chart");
            let chart = new ApexCharts(chartSelector, line_visits_chart_options);
            chart.render();
        });

        let line_reservations_chart_options = {
            series: [
                {name: reservationYearName, data: reservationYearData},
                {name: reservationMonthName, data: reservationMonthData},
                {name: reservationWeekName, data: reservationWeekData},
            ],
            colors: ['#27a444', '#3abad6', '#ffc107'],
            chart: {
                height: 350,
                type: 'area',
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                curve: 'smooth'
            },
            xaxis: {
                categories: reservationYearAxis,
            },
            legend: {
                show: false,
            },
            tooltip: {
                x: {
                    format: 'dd/MM/yy HH:mm',
                },
            },
        };

        $('.all_reservations_chart').click(function (e) {
            e.preventDefault();
            $('.reservations_chart_links').removeClass('disabled');
            $('#line_chart').html('');
            let chartSelector = document.querySelector("#line_chart");
            let chart = new ApexCharts(chartSelector, line_reservations_chart_options);
            chart.render();
        });


        $('.visits_chart_links, .reservations_chart_links').click(function (e) {
            $('#line_chart').html('');
            e.preventDefault();

            $(this).addClass('disabled');
            if($(this).hasClass('reservations_chart_links')){
                $(this).siblings('a').removeClass('disabled');
                $('a.visits_chart_links').removeClass('disabled');
            }

            if($(this).hasClass('visits_chart_links')){
                $(this).siblings('a').removeClass('disabled');
                $('a.reservations_chart_links').removeClass('disabled');
            }

            let axis = $(this).data('axis'),
                data = $(this).data('data'),
                name = $(this).children('p').html(),
                color = $(this).data('color');

            chart.updateOptions({
                xaxis: {
                    categories: axis,
                },
                series: [{name: name, data: data}],
                colors: [color],
            });
        });


    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/index.blade.php ENDPATH**/ ?>