<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::middleware('auth:api')->get('/user', function (Request $request) {
//    return $request->user();
//});


Route::group(['namespace' => 'API', 'middleware' => 'secret_token'], function () {

    Route::post('store-device-token', 'HomeController@storeDeviceToken');
    Route::get('info-collection', 'HomeController@infoCollection');
    Route::get('branches', 'HomeController@branches');
    Route::get('galleries', 'HomeController@galleries');

    Route::group(['prefix' => 'services'], function (){
        Route::get('/', 'ServiceController@index');
        Route::get('/{id}', 'ServiceController@show');
    });

    Route::group(['prefix' => 'booking'], function (){
        Route::get('/{booking_id}', 'BookingController@show');
        Route::get('/get-branches/{service_id}', 'BookingController@getBranches');
        Route::get('/get-doctors/{service_id}', 'BookingController@getDoctors');
        Route::get('/get-appointment-dates', 'BookingController@getAppointmentDates');
        Route::get('/get-appointment-times', 'BookingController@getAppointmentTimes');
        Route::post('/send-code', 'BookingController@sendCode');
        Route::post('/code-verification', 'BookingController@verifyCode');
        Route::post('/add/{service_id}', 'BookingController@addBooking');

        Route::post('evaluate/{booking_id}', 'BookingController@addEvaluate');

    });

    Route::post('contact-us', 'HomeController@contactUs');
    Route::get('notifications', 'HomeController@notifications');

    Route::group(['middleware' => 'api_auth'], function () {

//        Route::post('/save-payment', 'UserController@savePayment');

    });

});
