@extends('web.layouts.container')

@section('content')
    <section class="rooms_pg pt-0 inner_pg section">
        <div class="container">
            <div class="content content_box mt-0">
                <h3 class="title mb-4"> {{__('rooms.search_filter')}} : </h3>
                <form method="get" action="{{route('room.index')}}" class="search_form">
                    <div class="form">
                        <div class="row align-items-center">
                            <div class="col-lg-3">
                                <div class="form-group mb-4 select_group">
                                    <select name="branch_id" class="form-control form-select">
                                        <option value="">{{__('rooms.branch_id')}}</option>
                                    @if(count($branches))
                                            @foreach($branches as $branch)
                                                <option {{session('branch_id') == $branch->id ? 'selected' : ''}} value="{{$branch->id}}">{{$branch->name}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-4 select_group">
                                    <select name="room_type_id" class="form-control form-select">
                                        <option value="">{{__('rooms.room_type_id')}}</option>
                                        @if(is_countable($roomTypes))
                                            @foreach($roomTypes as $roomType)
                                                <option {{session('room_type_id') == $roomType->id ? 'selected' : ''}} value="{{$roomType->id}}">{{$roomType->name}}</option>
                                            @endforeach
                                            @else
                                            <option {{session('room_type_id') == $roomTypes->id ? 'selected' : ''}} value="{{$roomTypes->id}}">{{$roomTypes->name}}</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-4 select_group">
                                    <select name="person_count" class="form-control form-select">
                                        <option value="">{{__('rooms.person_count')}}</option>
                                        @for($i = 1; $i <= $personCounts; $i++)
                                            <option {{session('person_count') == $i ? 'selected' : ''}} value="{{$i}}">{{$i . ' ' . __('rooms.person')}}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-4 select_group">
                                    <select name="rate" class="form-control form-select">
                                        <option value="">{{__('rooms.rate')}}</option>
                                        <option {{session('rate') == 1 ? 'selected' : ''}} value="1"> {{__('rooms.1start')}} </option>
                                        <option {{session('rate') == 2 ? 'selected' : ''}} value="2"> {{__('rooms.2start')}} </option>
                                        <option {{session('rate') == 3 ? 'selected' : ''}} value="3"> {{__('rooms.3start')}} </option>
                                        <option {{session('rate') == 4 ? 'selected' : ''}} value="4"> {{__('rooms.4start')}} </option>
                                        <option {{session('rate') == 5 ? 'selected' : ''}} value="5"> {{__('rooms.5start')}} </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 mt-5">
                                <button class="butn primary_border_butn w-100 text-center search_button">
                                    <span> {{__('rooms.search')}} </span>
                                </button>
                            </div>
                            <div class="col-lg-6 mt-5 d-none d-lg-block">
                                <div class="list_grid_cont">
                                    <p class="p mb-0"> {{__('rooms.search_format')}} : </p>
                                    <span class="list_btn bttn search_format_buttons"> <i class="fas fa-list"></i> </span>
                                    <span class="grid_btn bttn active search_format_buttons"> <i class="fas fa-th-large"></i> </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="rooms_content rooms_container">
                    @if(count($rooms))
                        <div class="row">
                            @foreach($rooms as $room)
                                <div class="col-lg-4 list_grid_item">
                                    <div class="room_item">
                                        <div class="img">
                                            <img src="{{asset($room->image)}}" alt="">
                                            <span class="stars">
                                            @if($room->rate)
                                                    @for($i = 1; $i <= $room->rate; $i++)
                                                        <i class="far fa-star"></i>
                                                    @endfor
                                                @else
                                                    {{__('rooms.no_evaluates')}}
                                                @endif
                                        </span>

                                        </div>
                                        <div class="info">
                                            <h4 class="title">{{$room->name}}</h4>
                                            <div class="m_inf mt-2">
                                                <small class="label me-3">
                                                    <span> <i class="bi bi-info-circle me-1 color-primary"></i> {{__('rooms.room_type_id')}} : </span>{{$room->roomTypeName}}
                                                </small>
                                                <small class="label">
                                                    <span> <i class="bi bi-geo-alt me-1 color-primary"></i> {{__('rooms.branch_id')}} :</span> {{$room->branchName}}
                                                </small>
                                            </div>
                                            <div class="text mt-4">{{wordLimit(stripText($room->description), 15)}}</div>
                                            <a href="{{route('room.show', $room->id)}}" class="mor_btn"> <i class="bi bi-eye me-1"></i> {{__('rooms.see_room')}} </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <nav aria-label="Page navigation example">
                            {{$rooms->links()}}
                        </nav>
                    @else
                        <div class="alert alert-secondary text-center text-danger">{{__('rooms.no_data')}}</div>
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>

        let selectRoomTypeTitle = "{{__('rooms.room_type_id')}}",
            getRomTypesRoute = "{{route('room.getRoomTypes')}}";

        $('.search_button').click(async function (e) {
            e.preventDefault();

            let rooms_container = $('.rooms_container');

            rooms_container.html('');

            $(this).prop('disabled', true);

            let form = $('.search_form'),
                data = {
                branch_id: $('select[name="branch_id"]').val(),
                room_type_id: $('select[name="room_type_id"]').val(),
                person_count: $('select[name="person_count"]').val(),
                rate: $('select[name="rate"]').val(),
                },
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response){
                $(this).prop('disabled', false);
                rooms_container.html(response);
                $('.search_format_buttons.active').trigger('click');
            }

        });

        $('select[name="branch_id"]').change(async function(){

            let room_type_id = $('select[name="room_type_id"]');

            room_type_id.html('');

            if($(this).val() === ''){
                return false;
            }

            let data = {branch_id: $(this).val()},
                url = getRomTypesRoute,
                method = 'post';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.url){
                window.location.href = response.url;
            }

            if (response.room_types.length){
                room_type_id.html(`<option value="">${selectRoomTypeTitle}</option>`);
                for(let roomType of response.room_types){
                    room_type_id.append(`<option value="${roomType.id}">${roomType.name}</option>`)
                }
            }
        });


    </script>



    <script>
        let list_grid_cont = $('.list_grid_cont');
        list_grid_cont.on( "click" , ".list_btn" , function(){
            $(this).addClass("active").siblings().removeClass("active");
            $(".rooms_content").addClass("list_rooms");
            $(".rooms_content .col-lg-4").addClass("col-lg-6").removeClass("col-lg-4");
        });

        list_grid_cont.on( "click" , ".grid_btn" , function(){
            $(this).addClass("active").siblings().removeClass("active");
            $(".rooms_content").removeClass("list_rooms");
            $(".rooms_content .col-lg-6").addClass("col-lg-4").removeClass("col-lg-6");
        });
    </script>

@endsection
