@extends('web.layouts.container')

@section('content')
    <section class="about-sec section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <img src="{{asset('assets/web/')}}/images/about-1.png" alt="" class="sec-img"/>
                </div>
                <div class="col-lg-6">
                    <div class="text-box">
                        <h4 class="sec_title color-secondary mb-4">عن المركز</h4>
                        <h1 class="title mb-5">
                            <span class="color-primary">مركز بصمة</span> القدم للتأهيل الطبي
                        </h1>
                        <p class="p">
                            يعتبر مركز بصمة القدم أحد المركز الرائدة في مجال التأهيل بالمملكة العربية السعودية حيث يساهم المركز في رفع مستوى وجودة خدمات التأهيل بالمملكة من خلال استقطاب أفضل الكوادر المتخصصة واستخدام احث تقنيات التشخيص والعلاج.
                        </p>
                        <p class="p">
                            قمنا بتأسيس مركز بصمة القدم للتأهيل الطبي ليكون المكان ذو الطابع الأنسب للعلاج والتأهيل الطبي، مع عناية فائقة. نستقطب من أجله أفضل المتخصصين والخبراء والتقنيات الحديثة ، كي تخرجوا من المركز وانتم بأتم الرضاء والصحة والعافية.
                        </p>
                    </div>
                    <div class="down_links d-flex mt-5">
                        <a href="#">
                            <img src="{{asset('assets/web/')}}/images/icons/apple_store.svg" alt="" class="down_img"/>
                        </a>
                        <a href="#">
                            <img src="{{asset('assets/web/')}}/images/icons/play_store.svg" alt="" class="down_img"/>
                        </a>
                    </div>
                    <!-- <a href="#" class="butn primary_butn mt-5 px-5"><b> قراءة المزيد  </b></a> -->

                </div>
            </div>
        </div>
        <img src="{{asset('assets/web/')}}/images/pattern-1.svg" alt="" class="pattern"/>
    </section>
    <!-- Start services-sec -->
    <section class="services-sec section">
        <div class="container">
            <h1 class="sec_title mb-5"> خدماتنا الطبية  </h1>
            <div class="swiper-container services_swiper pb-5">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="serv_card">
                            <a href="#">
                                <img src="{{asset('assets/web/')}}/images/services-1.png" alt="" class="sec-img serv_img"/>
                            </a>
                            <div class="card-body">
                                <a href="#" class="title fs-5 fw-bold ">
                                    الأطراف الصناعية والأجهزة التعويضية <br>
                                    P&O
                                </a>
                                <p class="p">
                                    هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التركيز على الشكل الخارجي للنص
                                </p>
                                <a href="#" class="butn primary_butn m-auto">احجز موعد</a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="serv_card">
                            <a href="#">
                                <img src="{{asset('assets/web/')}}/images/services-2.png" alt="" class="sec-img serv_img"/>
                            </a>
                            <div class="card-body">
                                <a href="#" class="title fs-5 fw-bold ">
                                    بصمة القدم <br>
                                    Foot Biomechanics
                                </a>
                                <p class="p">
                                    هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التركيز على الشكل الخارجي للنص
                                </p>
                                <a href="#" class="butn primary_butn m-auto">احجز موعد</a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="serv_card">
                            <a href="#">
                                <img src="{{asset('assets/web/')}}/images/services-3.png" alt="" class="sec-img serv_img"/>
                            </a>
                            <div class="card-body">
                                <a href="#" class="title fs-5 fw-bold ">
                                    تحسين السمع  <br>
                                    Audio Therapy
                                </a>
                                <p class="p">
                                    هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التركيز على الشكل الخارجي للنص
                                </p>
                                <a href="#" class="butn primary_butn m-auto">احجز موعد</a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="serv_card">
                            <a href="#">
                                <img src="{{asset('assets/web/')}}/images/services-5.png" alt="" class="sec-img serv_img"/>
                            </a>
                            <div class="card-body">
                                <a href="#" class="title fs-5 fw-bold ">
                                    تحسين النطق والتخاطب <br>
                                    Speech Therapy
                                </a>
                                <p class="p">
                                    هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التركيز على الشكل الخارجي للنص
                                </p>
                                <a href="#" class="butn primary_butn m-auto">احجز موعد</a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="serv_card">
                            <a href="#">
                                <img src="{{asset('assets/web/')}}/images/services-4.png" alt="" class="sec-img serv_img"/>
                            </a>
                            <div class="card-body">
                                <a href="#" class="title fs-5 fw-bold ">
                                    العلاج الوظيفي <br>
                                    Occupational Therapy
                                </a>
                                <p class="p">
                                    هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التركيز على الشكل الخارجي للنص
                                </p>
                                <a href="#" class="butn primary_butn m-auto">احجز موعد</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start doctors-sec -->
    <section class="doctors-sec section bg-light">
        <div class="container">
            <h1 class="sec_title mb-5">   أطباؤنا  </h1>
            <div class="swiper-container dr_swiper pb-5">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="dr_card">
                            <img src="{{asset('assets/web/')}}/images/dr-1.png" alt="" class="sec-img"/>
                            <div class="dr_data">
                                <h5 class="name color-primary ">إسم الدكتور</h5>
                                <h6 class="job mb-0">أخصائي الأطراف التعويضية</h6>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="dr_card">
                            <img src="{{asset('assets/web/')}}/images/dr-2.png" alt="" class="sec-img"/>
                            <div class="dr_data">
                                <h5 class="name color-primary ">إسم الدكتور</h5>
                                <h6 class="job mb-0">أخصائي الأطراف التعويضية</h6>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="dr_card">
                            <img src="{{asset('assets/web/')}}/images/dr-3.png" alt="" class="sec-img"/>
                            <div class="dr_data">
                                <h5 class="name color-primary ">إسم الدكتور</h5>
                                <h6 class="job mb-0">أخصائي الأطراف التعويضية</h6>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="dr_card">
                            <img src="{{asset('assets/web/')}}/images/dr-2.png" alt="" class="sec-img"/>
                            <div class="dr_data">
                                <h5 class="name color-primary ">إسم الدكتور</h5>
                                <h6 class="job mb-0">أخصائي الأطراف التعويضية</h6>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start feedback-sec -->
    <section class="feedback-sec section">
        <div class="container">
            <h1 class="sec_title text-white mb-5">   آراء عملاؤنا  </h1>
            <div class="swiper-container feedback_swiper pb-5">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="feedback_card">
                            <h1 class="quote_icon color-secondary mb-3"><i class="fa-solid fa-quote-right"></i></h1>
                            <p class="p">
                                مركز متكامل لديهم احدث الاجهزة الخاصة للكشف وعلاج القدم او الظهر وايضاً لديهم المعمل الخاص لتصنيع الحشوات او الجبيرة او الدعمات الخاصة للظهر والقدم
                            </p>
                            <div class="prof_data">
                                <h5 class="name"><b>Marwa Saad</b></h5>
                                <div class="stars">
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="feedback_card">
                            <h1 class="quote_icon color-secondary mb-3"><i class="fa-solid fa-quote-right"></i></h1>
                            <p class="p">
                                مركز متكامل لديهم احدث الاجهزة الخاصة للكشف وعلاج القدم او الظهر وايضاً لديهم المعمل الخاص لتصنيع الحشوات او الجبيرة او الدعمات الخاصة للظهر والقدم
                            </p>
                            <div class="prof_data">
                                <h5 class="name"><b>Marwa Saad</b></h5>
                                <div class="stars">
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="feedback_card">
                            <h1 class="quote_icon color-secondary mb-3"><i class="fa-solid fa-quote-right"></i></h1>
                            <p class="p">
                                مركز متكامل لديهم احدث الاجهزة الخاصة للكشف وعلاج القدم او الظهر وايضاً لديهم المعمل الخاص لتصنيع الحشوات او الجبيرة او الدعمات الخاصة للظهر والقدم
                            </p>
                            <div class="prof_data">
                                <h5 class="name"><b>Marwa Saad</b></h5>
                                <div class="stars">
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star "></i>
                                    <i class="fa-solid fa-star"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="feedback_card">
                            <h1 class="quote_icon color-secondary mb-3"><i class="fa-solid fa-quote-right"></i></h1>
                            <p class="p">
                                مركز متكامل لديهم احدث الاجهزة الخاصة للكشف وعلاج القدم او الظهر وايضاً لديهم المعمل الخاص لتصنيع الحشوات او الجبيرة او الدعمات الخاصة للظهر والقدم
                            </p>
                            <div class="prof_data">
                                <h5 class="name"><b>Marwa Saad</b></h5>
                                <div class="stars">
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star active"></i>
                                    <i class="fa-solid fa-star "></i>
                                    <i class="fa-solid fa-star "></i>
                                    <i class="fa-solid fa-star"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start gallery-sec -->
    <section class="gallery-sec section bg-light">
        <div class="container">
            <h1 class="sec_title mb-5">  معرض الصور والفيديوهات  </h1>
            <ul class="nav nav-pills mb-5" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="pills-tab1-tab" data-bs-toggle="pill" data-bs-target="#pills-tab1" type="button" role="tab" aria-controls="pills-tab1" aria-selected="true">الكل</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-tab2-tab" data-bs-toggle="pill" data-bs-target="#pills-tab2" type="button" role="tab" aria-controls="pills-tab2" aria-selected="false">صور</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-tab3-tab" data-bs-toggle="pill" data-bs-target="#pills-tab3" type="button" role="tab" aria-controls="pills-tab3" aria-selected="false">فيديو</button>
                </li>
            </ul>
            <div class="swiper-container gallery_swiper pb-5">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="gallery_card vid_card h_lg">
                                    <img src="{{asset('assets/web/')}}/images/header-1.png" alt="" class="sec-img"/>
                                    <a class="button is-play" data-fancybox href="https://www.youtube.com/watch?v=mkggXE5e2yk">
                                        <div class="button-outer-circle has-scale-animation"></div>
                                        <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                        <div class="button-icon is-play">
                                            <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="gallery_card h_md">
                                            <a href="images/gallery-1.png" data-fancybox="images">
                                                <img src="{{asset('assets/web/')}}/images/gallery-1.png" alt="" class="sec-img"/>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="gallery_card h_md">
                                            <a href="images/gallery-3.png" data-fancybox="images">
                                                <img src="{{asset('assets/web/')}}/images/gallery-3.png" alt="" class="sec-img"/>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="gallery_card vid_card h_md">
                                            <img src="{{asset('assets/web/')}}/images/gallery-2.png" alt="" class="sec-img"/>
                                            <a class="button is-play" data-fancybox href="https://www.youtube.com/watch?v=mkggXE5e2yk">
                                                <div class="button-outer-circle has-scale-animation"></div>
                                                <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                <div class="button-icon is-play">
                                                    <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="gallery_card vid_card h_lg">
                                    <img src="{{asset('assets/web/')}}/images/header-2.jpg" alt="" class="sec-img"/>
                                    <a class="button is-play" data-fancybox href="https://www.youtube.com/watch?v=mkggXE5e2yk">
                                        <div class="button-outer-circle has-scale-animation"></div>
                                        <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                        <div class="button-icon is-play">
                                            <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="gallery_card h_md">
                                            <a href="images/header-1.png" data-fancybox="images">
                                                <img src="{{asset('assets/web/')}}/images/header-1.png" alt="" class="sec-img"/>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="gallery_card h_md">
                                            <a href="images/gallery-2.png" data-fancybox="images">
                                                <img src="{{asset('assets/web/')}}/images/gallery-2.png" alt="" class="sec-img"/>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="gallery_card vid_card h_md">
                                            <img src="{{asset('assets/web/')}}/images/gallery-1.png" alt="" class="sec-img"/>
                                            <a class="button is-play" data-fancybox href="https://www.youtube.com/watch?v=mkggXE5e2yk">
                                                <div class="button-outer-circle has-scale-animation"></div>
                                                <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                <div class="button-icon is-play">
                                                    <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start contact-sec -->
    <section class="contact-sec section py-0">
        <div class="map_box">
            <iframe width="100%" height="500" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=1%20Grafton%20Street,%20Dublin,%20Ireland+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
            <div class="container">
                <div class="col-lg-5 ms-auto">
                    <div class="contact_box">
                        <h2 class="sec_title text-white mb-5"> معلومات التواصل </h2>
                        <p class="data_item">
                            <img src="{{asset('assets/web/')}}/images/icons/contact-1.svg" alt="" class="icon me-2"/> مركز نورا التجاري، طريق الملك عبدالعزيز، حي المرسلات - الرياض
                        </p>
                        <p class="data_item">
                            <img src="{{asset('assets/web/')}}/images/icons/contact-2.svg" alt="" class="icon me-2"/> 0557988545 - 9200 12218
                        </p>
                        <p class="data_item">
                            <img src="{{asset('assets/web/')}}/images/icons/contact-3.svg" alt="" class="icon me-2"/> info@footprint.sa
                        </p>
                        <div class="social_links d-flex mt-5">
                            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                            <a href="#"><i class="fa-brands fa-twitter"></i></a>
                            <a href="#"><i class="fa-brands fa-instagram"></i></a>
                            <a href="#"><i class="fa-brands fa-linkedin-in"></i></a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="contact_inner">
            <div class="container-fluid px-0">
                <div class="row align-items-center">
                    <div class="col-lg-6 px-0">
                        <div class="form_box h-100">
                            <h2 class="sec_title text-white mb-4"> اتصل بنا </h2>

                            <form>
                                <div class="form-group mb-3">
                                    <input class="form-control" placeholder="الإسم" type="text"/>
                                </div>
                                <div class="form-group mb-3">
                                    <input class="form-control" placeholder="البريد الإلكتروني" type="text"/>
                                </div>
                                <div class="form-group mb-3">
                                    <input class="form-control" placeholder="رقم الجوال" type="text"/>
                                </div>
                                <div class="form-group mb-3">
                                    <textarea class="form-control" placeholder=" الرسالة  " rows="5"></textarea>
                                </div>
                                <button class="butn w-100 white_border_butn"><b>ارسال</b></button>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-6 px-0">
                        <div class="hours_box h-100">
                            <h2 class="sec_title text-white mb-5"> ساعات العمل   </h2>
                            <p class="hours_item text-white mb-4">
                                من الأحد  إلى الخميس: ٩ صباحاً - ١٠ مساءً
                            </p>
                            <p class="hours_item text-white mb-4">
                                السبت: ١٠ صباحاً - ٨ مساءً
                            </p>
                            <p class="hours_item text-white mb-4">
                                الجمعة: مغلق
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

@endsection
