@extends('web.layouts.container')

@section('content')
    <section class="branches-pg bg-light section ">
        <div class="container">
            <div class="search_box col-lg-6 m-auto">
                <form action="{{route('branch.index')}}" method="get">
                    <div class="form-group">
                        <input name="branch_name" class="form-control" placeholder="{{__('branches.search')}}" type="search" value="{{session('branch_name')}}"/>
                        <button class="submit_butn"><img src="{{asset('assets/web/images/icons/search.svg')}}" alt="" class="filterSecondary icon"/></button>
                    </div>
                </form>
            </div>
            <div class="row mt-5">
                @if(count($branches))
                    @foreach($branches as $branch)
                        <div class="col-lg-4 col-md-6">
                            <div class="branch_card">
                                <h5 class="title fw-bold d-flex align-items-center mb-4">
                                    <span class="icon"><i class="fa-solid fa-location-dot"></i></span>
                                    {{$branch->name}}
                                </h5>
                                <p class="p mb-4">
                                    <img src="{{asset('assets/web/images/icons/contact_cards_3.svg')}}" alt="" class="sm_icon"/>
                                    {{$branch->address}}
                                </p>
                                <p class="p mb-4">
                                    <img src="{{asset('assets/web/images/icons/contact_cards_2.svg')}}" alt="" class="sm_icon"/>
                                    {{$branch->phone}}
                                </p>
                                <a data-map="{{$branch->map}}" href="#" class="butn gray_butn color-primary fw-bold w-100 map_link" data-bs-toggle="modal" data-bs-target="#showMapModal">
                                    {{__('branches.show_branch_on_map')}}
                                </a>
                            </div>
                        </div>
                    @endforeach
                    @else
                    <div class="alert text-white text-center col-lg-12" style="background-color: #3659a3">{{__('branches.no_data')}}</div>
                @endif
            </div>
        </div>
    </section>
    <!-- Modal -->
    <div class="modal fade map_modal" id="showMapModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg  modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                <div class="modal-body">
                    <div class="map_box map_container"></div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('inner_js')
    <script>
        $('.map_link').click(function () {
            $('.map_modal .modal-body .map_container').html($($(this).data('map')));
            $('.map_modal .modal-body .map_container iframe').attr('width', '100%').attr('height', '300');
        })
    </script>
@endsection
