@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{asset('assets/web/css/lib/datepicker.min.css')}}">
@endsection
@section('content')
    <section class="booking-pg bg-light section ">
        <div class="container">
            <div class="inner">
                <h1 class="sec_title m-auto mb-5">  {{$service->name}}  </h1>
                <div class="session_time d-flex justify-content-center align-items-center">
                    <img src="{{asset('assets/web/images/icons/clock.svg')}}" alt="" class="icon"/>
                    <div class="txt">
                        <h5 class="title fw-bold">{{__('reservations.session_duration')}}</h5>
                        <p class="p fs-6 mb-0">{{$service->durations . __('reservations.minutes')}} </p>
                    </div>
                </div>
                <div class="box">
                    <div class="form-wizard">
                        <form action="{{route('booking.addBooking', $service->id)}}" method="post" class="add_booking_form" role="form">
                            <div class="form-wizard-header my-5">
                                <ul class="list-unstyled form-wizard-steps clearfix">
                                    <li class="active">
                                        <span>1</span>
                                        <p class="title_li mb-0">{{__('reservations.choose_branch')}}</p>
                                    </li>
                                    <li>
                                        <span>2</span>
                                        <p class="title_li mb-0">{{__('reservations.choose_doctor')}}</p>
                                    </li>
                                    <li>
                                        <span>3</span>
                                        <p class="title_li mb-0">{{__('reservations.determine_reservation_date')}}</p>
                                    </li>
                                    <li>
                                        <span>4</span>
                                        <p class="title_li mb-0">{{__('reservations.user_info')}}</p>
                                    </li>
                                </ul>
                            </div>
                            {{-- Branches Block --}}
                            <fieldset class="wizard-fieldset show">
                                <h3 class="sec_title mb-5">{{__('reservations.choose_branch')}}</h3>
                                <div class="branch_radios">
                                    <div class="swiper-container branchRadios_swiper pb-4">
                                        <div class="swiper-wrapper">
                                            @if(count($branches))
                                                @foreach($branches as $branch)
                                            <div class="swiper-slide">
                                                <div class="form-check">
                                                    <input {{$loop->iteration == 1 ? 'checked' : ''}} class="form-check-input" type="radio" name="branch_id" id="branchRadio{{$loop->iteration}}" value="{{$branch->id}}">
                                                    <label class="form-check-label" for="branchRadio{{$loop->iteration}}">
                                                        <div class="branch_card">
                                                            <h5 class="title fw-bold d-flex align-items-center mb-4">
                                                                <span class="icon"><i class="fa-solid fa-location-dot"></i></span>
                                                                {{$branch->name}}
                                                            </h5>
                                                            <p class="p mb-4">
                                                                <img src="{{asset('assets/web/images/icons/contact_cards_3.svg')}}" alt="" class="sm_icon"/>
                                                                {{$branch->address}}
                                                            </p>
                                                            <p class="p mb-4">
                                                                <img src="{{asset('assets/web/images/icons/contact_cards_2.svg')}}" alt="" class="sm_icon"/>
                                                                {{$branch->phone}}
                                                            </p>
                                                            <a data-map="{{$branch->map}}" href="#" class="butn gray_butn color-primary fw-bold w-100 map_link" data-bs-toggle="modal" data-bs-target="#showMapModal">
                                                                {{__('branches.show_branch_on_map')}}
                                                            </a>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                                @endforeach
                                            @else
                                                <div class="alert text-white text-center col-lg-12" style="background-color: #3659a3">{{__('branches.no_data')}}</div>
                                            @endif
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <div class="form-group clearfix justify-content-center w-100 d-flex mt-5">
                                    <a href="javascript:;" class="form-wizard-next-btn butn secondary_butn px-5 mx-4 next_step_to_doctors">{{__('reservations.next')}}</a>
                                </div>
                            </fieldset>

                            {{-- Doctors Block --}}
                            <fieldset class="wizard-fieldset">
{{--                                <input type="hidden" name="rand_doctor_id">--}}
                                <h3 class="sec_title mb-5">{{__('reservations.choose_doctor')}}</h3>
                                @if(count($doctors))
                                <div class="d-flex">
                                    <div class="form-check me-5">
                                        <input class="form-check-input" value="1" type="radio" name="specific_doctor_way" id="specialistAvailRadio1" checked>
                                        <label class="form-check-label" for="specialistAvailRadio1">
                                            {{__('reservations.specific_doctor')}}
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" value="2" type="radio" name="specific_doctor_way" id="specialistAvailRadio2" >
                                        <label class="form-check-label" for="specialistAvailRadio2">
                                            {{__('reservations.specific_doctor_by_center')}}
                                        </label>
                                    </div>
                                </div>
                                @endif
                                <div class="specialist_radios mt-5" id="specialist_radios">
                                    @if(count($doctors))
                                    <div class="swiper-container specialistRadios_swiper pb-4">
                                        <div class="swiper-wrapper">
                                            @foreach($doctors as $doctor)
                                                <div class="swiper-slide">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" name="doctor_id" id="specialistRadio{{$loop->iteration}}" value="{{$doctor->id}}">
                                                        <label class="form-check-label" for="specialistRadio{{$loop->iteration}}">
                                                            <div class="specialist_card">
                                                                <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                                                                <div class="content">
                                                                    <h5 class="name text-white fw-bold">{{$doctor->name}}</h5>
                                                                    <p class="job mb-0">{{$doctor->specialist}}</p>
                                                                </div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                    @else
                                        <div class="alert alert-secondary text-danger text-center col-lg-12">{{__('reservations.no_data')}}</div>
                                    @endif
                                </div>
                                <div class="form-group clearfix justify-content-center w-100 d-flex mt-5">
                                    <a href="javascript:;" class="form-wizard-previous-btn butn primary_border_butn px-5 mx-4">{{__('reservations.prev')}}</a>
                                    @if(count($doctors))
                                        <a href="javascript:;" class="form-wizard-next-btn butn secondary_butn px-5 mx-4 next_step_to_calender d-none">{{__('reservations.next')}}</a>
                                    @endif
                                </div>
                            </fieldset>

                            {{-- Reservation date block--}}
                            <fieldset class="wizard-fieldset">
                                <h3 class="sec_title mb-5">{{__('reservations.determine_reservation_date')}}</h3>
                                <div class="row">
                                    <div class="col-lg-7">
                                        <div class="sm_box mb-4">
                                            <div class="tab-content" id="nav-tabContent0">
                                                <div class="tab-pane fade show active" id="nav-tab1" role="tabpanel" aria-labelledby="nav-tab1-tab">
                                                    <div class="session_time_radios mt-4">
                                                        <div class="swiper-container sessionTime_swiper">
                                                            <div class="swiper-wrapper pb-5 appointment_dates_container"></div>
                                                            <div class="swiper-pagination"></div>
                                                        </div>
                                                    </div>
                                                </div>
{{--                                                <div class="tab-pane fade show active" id="nav-tab0" role="tabpanel" aria-labelledby="nav-tab1-tab">--}}
{{--                                                    <div class="session_time_radios mt-4">--}}
{{--                                                        <div class="swiper-container sessionTime_swiper">--}}
{{--                                                            <div class="swiper-wrapper pb-5 appointment_dates_container">--}}
{{--                                                                @if(count($availableDates))--}}
{{--                                                                    @foreach($availableDates as $availableDate)--}}
{{--                                                                        <div class="swiper-slide">--}}
{{--                                                                            <div class="form-check">--}}
{{--                                                                                <input class="form-check-input" type="radio" name="appointment_date" id="sessionDateRadio{{$loop->iteration}}" value="{{date('Y-m-d', strtotime($availableDate))}}">--}}
{{--                                                                                <label class="form-check-label" for="sessionDateRadio{{$loop->iteration}}">--}}
{{--                                                                                    <div class="sessionTime_card">--}}
{{--                                                                                        {{$availableDate}}--}}
{{--                                                                                    </div>--}}
{{--                                                                                </label>--}}
{{--                                                                            </div>--}}
{{--                                                                        </div>--}}
{{--                                                                    @endforeach--}}
{{--                                                                @endif--}}
{{--                                                            </div>--}}
{{--                                                            <div class="swiper-pagination"></div>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
                                            </div>

{{--                                            <div class="date_group">--}}
{{--                                                <div class="session_time_radios mt-4">--}}
{{--                                                    <div class="swiper-container sessionTime_swiper">--}}
{{--                                                        <div class="swiper-wrapper pb-5 appointment_dates_container">--}}

{{--                                                        </div>--}}
{{--                                                        <div class="swiper-pagination"></div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}

{{--                                                <div class="datepicker"></div>--}}
{{--                                            </div>--}}
                                        </div>
                                        <div class="sm_box appointment_time_container">
                                            <nav>
                                                <div class="nav justify-content-center nav-tabs" id="nav-tab" role="tablist">
                                                    <button class="nav-link active" id="nav-tab1-tab" data-bs-toggle="tab" data-bs-target="#nav-tab2" type="button" role="tab" aria-controls="nav-tab1" aria-selected="true">{{__('reservations.morning')}}</button>
                                                    <button class="nav-link" id="nav-tab2-tab" data-bs-toggle="tab" data-bs-target="#nav-tab3" type="button" role="tab" aria-controls="nav-tab2" aria-selected="false">{{__('reservations.evening')}}</button>
                                                </div>
                                            </nav>
                                            {{-- Appointment Times Block --}}
                                            <div class="tab-content" id="nav-tabContent">
                                                {{-- AM tap pane Block--}}
                                                <div class="tab-pane fade show active" id="nav-tab2" role="tabpanel" aria-labelledby="nav-tab1-tab">
                                                    <div class="session_time_radios mt-4">
                                                        <span class="text-danger appointment_time_am_no_data">{{__('reservations.no_data')}}</span>
                                                        <div class="swiper-container sessionTime_swiper">
                                                            <div class="swiper-wrapper pb-5 available_times_am"> </div>
                                                            <div class="swiper-pagination"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                {{-- PM tap pane Block--}}
                                                <div class="tab-pane fade" id="nav-tab3" role="tabpanel" aria-labelledby="nav-tab2-tab">
                                                    <div class="session_time_radios mt-4">
                                                        <span class="text-danger appointment_time_pm_no_data">{{__('reservations.no_data')}}</span>
                                                        <div class="swiper-container sessionTime_swiper">
                                                            <div class="swiper-wrapper pb-5 available_times_pm"></div>
                                                            <div class="swiper-pagination"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <div class="sm_box pt-4 h-100 px-4 mb-4">
                                            <h5 class="sec_title mb-5">{{__('reservations.reservation_date')}}</h5>
                                            <div class="booking_det d-flex align-items-center">
                                                <img src="{{asset('assets/web/images/icons/booking-1.svg')}}" alt="" class="icon"/>
                                                <div class="txt">
                                                    <p class="p mb-1 appointment_date_info_container"></p>
                                                    <h5 class="name mb-0 doctor_name_container"></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group clearfix justify-content-center w-100 d-flex mt-5">
                                    <a href="javascript:;" class="form-wizard-previous-btn butn primary_border_butn px-5 mx-4">{{__('reservations.prev')}}</a>
                                    <a href="javascript:;" class="form-wizard-next-btn butn secondary_butn px-5 mx-4 next_step_to_user_info d-none">{{__('reservations.next')}}</a>
                                </div>
                            </fieldset>

                            {{-- User info block--}}
                            <fieldset class="wizard-fieldset">
                                <h3 class="sec_title mb-5">{{__('reservations.user_info')}}</h3>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="userData_box">
                                            <div class="form-group mb-4">
                                                <label class="label mb-2">{{__('reservations.name')}} <span class="text-danger">*</span></label>
                                                <input class="form-control" name="name" placeholder="{{__('reservations.type_here')}}" type="text"/>
                                            </div>
                                            <div class="form-group mb-4">
                                                <label class="label mb-2">{{__('reservations.email')}}<span class="text-danger">*</span></label>
                                                <input style="direction: rtl" class="form-control" name="email" placeholder="{{__('reservations.type_here')}}" type="email"/>
                                            </div>
                                            <div class="form-group mb-4">
                                                <label class="label mb-2">{{__('reservations.phone')}}<span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text" id="basic-addon1">+966</span>
                                                    <input style="direction: rtl" type="tel" name="phone" class="form-control" placeholder="XXXXXXXXXXXX">
                                                </div>
                                                <button class="apply_abs_butn fs-4 send_code"><i class="bi bi-arrow-left"></i></button>
                                                <b class="temp_code text-danger"></b>
                                            </div>
                                            <div class="form-group mb-4 d-none verify_code_container">
                                                <label class="label mb-2">{{__('reservations.verify_code')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="verify_code" class="form-control" placeholder="{{__('reservations.verify_code')}}">
                                                <button class="apply_abs_butn fs-6 check_verify_code_button">{{__('reservations.verify')}}</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group clearfix justify-content-center w-100 d-flex mt-5">
                                    <a href="#" class="form-wizard-previous-btn butn primary_border_butn px-5 mx-4">{{__('reservations.prev')}}</a>
                                    <button class="form-wizard-submit butn secondary_butn px-5 mx-4 bg-secondary complete_reservation_button" disabled>{{__('reservations.complete_reservation')}}</button>
                                </div>
                            </fieldset>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade map_modal" id="showMapModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg  modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-body">
                    <div class="map_box map_container"> </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('inner_js')



    <script>

        let getAppointmentTimesRoute = "{{route('booking.getAppointmentDatesAndTimes')}}",
            sendCodeRoute = "{{route('booking.sendCode')}}",
            checkVerifyCodeRoute = "{{route('booking.verifyCode')}}",
            service_id = "{{$service->id}}",
            randomDoctorId = null,
            noData = "{{__('reservations.no_data')}}";

        $('.complete_reservation_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.add_booking_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            data.append('rand_doctor_id', randomDoctorId);

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                setTimeout(function () {
                    window.location.href = response.url;
                }, 200)
            }

        });

        $('.send_code').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let data = {
                name: $('input[name="name"]').val(),
                email: $('input[name="email"]').val(),
                phone: $('input[name="phone"]').val(),
                },
                url = sendCodeRoute,
                method = 'post';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                $('.verify_code_container').addClass('d-none');
                $('input[name="verify_code"]').val(null);
                toasterError(response.errors);
            }

            if (response.success){
                $(this).prop('disabled', false);
                $('.verify_code_container').removeClass('d-none');
                $('.temp_code').html(response.code);
                toasterSuccess(response.message);
            }

        });

        $('.check_verify_code_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let data = {
                    name: $('input[name="name"]').val(),
                    email: $('input[name="email"]').val(),
                    phone: $('input[name="phone"]').val(),
                    verify_code: $('input[name="verify_code"]').val(),
                },
                url = checkVerifyCodeRoute,
                method = 'post';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                $(this).prop('disabled', true).addClass('bg-secondary');
                toasterSuccess(response.message);
                $('.complete_reservation_button').prop('disabled', false).removeClass('bg-secondary');
            }

        });

        $(document).on('click', 'input[name="appointment_date"]', function () {
            $('.next_step_to_user_info').addClass('d-none');
            $('.available_times_am').html('');
            $('.available_times_pm').html('');
            $('.appointment_time_pm_no_data').html('');
            $('.appointment_time_am_no_data').html('');
            checkAvailableTimes({get_available_times: true});
            let date = new Date($(this).val()).toDateString();
            // Saturday, Jan 8, 2022 at 9:00 p.m
            $('.appointment_date_info_container').html(date);

        });

        $('.next_step_to_calender').click(function () {
            let selectedDoctor = $('input[name="doctor_id"]:checked'),
            doctorNameContainer = $('.doctor_name_container');
            $('.appointment_date_info_container').html('');
            $('.appointment_dates_container').html(`<span class="text-danger">${noData}</span>`);
            $('.available_times_am').html('');
            $('.available_times_pm').html('');
            $('.appointment_time_am_no_data').html(`${noData}`);
            $('.appointment_time_pm_no_data').html(`${noData}`);
            doctorNameContainer.html('');

            if(selectedDoctor.length){
                checkAvailableDates();
                let doctorName = selectedDoctor.siblings('label')
                    .children('.specialist_card').children('.content')
                    .children('h5').html();
                // doctorNameContainer.html(doctorName)
            } else {
                checkAvailableDates();
                // doctorNameContainer.html('')
            }
        });

        async function checkAvailableDates(appendedData = null) {
            let appointmentDateContainer = $('.appointment_dates_container'),
                doctorNameContainer = $('.doctor_name_container');

            let data = {
                    specific_doctor_way : $('input[name="specific_doctor_way"]:checked').val(),
                    doctor_id : $('input[name="doctor_id"]:checked').val(),
                    appointment_date : $('input[name="appointment_date"]:checked').val(),
                    service_id : service_id,
                },
                url = getAppointmentTimesRoute,
                method = 'post';

            if(appendedData){
                data = {...data, ...appendedData}
            }

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if(response.random_doctor_id){
                randomDoctorId = response.random_doctor_id;
                // $('input[name="rand_doctor_id"]').val(response.doctor_id);
            }
            if (response.appointment_date){
                appointmentDateContainer.html('');
                let counter = 1;
                for(let appointmentDate of response.appointment_date){
                    appointmentDateContainer.append(`
                        <div class="swiper-slide">
                            <div class="form-check">
                                <input value="${appointmentDate}" class="form-check-input" type="radio" name="appointment_date" id="appointment_date_${counter}">
                                <label class="form-check-label" for="appointment_date_${counter}">
                                    <div class="sessionTime_card">
                                        ${appointmentDate}
                                     </div>
                                </label>
                            </div>
                        </div>`);
                    counter++;
                }
            }

            if(response.doctor_name){
                doctorNameContainer.html(response.doctor_name);
            }
        }

        async function checkAvailableTimes(appendedData = null) {
            let doctorNameContainer = $('.doctor_name_container'),
                availableTimeAm = $('.available_times_am'),
                availableTimePm = $('.available_times_pm'),
                availableTimeAmNoData = $('.appointment_time_am_no_data'),
                availableTimePmNoData = $('.appointment_time_pm_no_data');

            availableTimeAm.html('');
            availableTimePm.html('');
            availableTimeAmNoData.html('');
            availableTimePmNoData.html('');

            let data = {
                    specific_doctor_way : $('input[name="specific_doctor_way"]:checked').val(),
                    doctor_id : $('input[name="doctor_id"]:checked').val(),
                    appointment_date : $('input[name="appointment_date"]:checked').val(),
                    service_id : service_id,
                },
                url = getAppointmentTimesRoute,
                method = 'post';

            if(appendedData){
                data = {...data, ...appendedData}
            }

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if(response.random_doctor_id){
                randomDoctorId = response.random_doctor_id;
                // $('input[name="rand_doctor_id"]').val(response.doctor_id);
            }

            if(response.available_time_am.length){
                availableTimeAm.html('');
                availableTimeAmNoData.html('');
                let counter = 0;
                for(let availableTime of response.available_time_am){
                    availableTimeAm.append(`
                            <div class="swiper-slide">
                                <div class="form-check">
                                    <input data-time="${availableTime}" value="${response.available_time_am_ids[counter]}" class="form-check-input" type="radio" name="appointment_time" id="available_time_am_${counter}">
                                    <label class="form-check-label" for="available_time_am_${counter}">
                                        <div class="sessionTime_card">
                                            ${availableTime}
                                        </div>
                                    </label>
                                </div>
                            </div>`);

                    counter++;
                }
            } else {
                availableTimeAmNoData.html(`${noData}`);
            }
            if(response.available_time_pm.length){
                availableTimePm.html('');
                availableTimePmNoData.html('');
                let counter = 0;
                for(let availableTime of response.available_time_pm){
                    availableTimePm.append(`
                            <div class="swiper-slide">
                                <div class="form-check">
                                    <input data-time="${availableTime}" value="${response.available_time_pm_ids[counter]}" class="form-check-input" type="radio" name="appointment_time" id="available_time_pm_${counter}">
                                    <label class="form-check-label" for="available_time_pm_${counter}">
                                        <div class="sessionTime_card">
                                            ${availableTime}
                                        </div>
                                    </label>
                                </div>
                            </div>`);
                    counter++;
                }
            } else {
                availableTimePmNoData.html(`${noData}`);
            }

            if(response.doctor_name){
                doctorNameContainer.html(response.doctor_name);
            }
        }

        </script>

    <script src="{{asset('assets/web/js/lib/datepicker.min.js')}}"></script>
    <script src="{{asset('assets/web/js/booking.js')}}"></script>

@endsection
