@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_reply_form" method="post" action="{{ $action }}">
        @if($visitorMessage ?? ''  && $visitorMessage->id ?? '')
            @method('PUT')
        @endif
        @csrf

        @if ($visitorMessage ?? '')
{{--        <div class="form-group col-lg-4">--}}
{{--            <label>{{ meta('name', $lang) ?? __('visitorMessages.name') }} </label>--}}
{{--            <p class="form-control" style="height: auto">{{$visitorMessage->name}}</p>--}}
{{--        </div>--}}
        <div class="form-group col-lg-6">
            <label>{{ meta('visitor_email', $lang) ?? __('visitorMessages.email') }} </label>
            <p class="form-control" style="height: auto">{{$visitorMessage->email}}</p>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('phone', $lang) ?? __('visitorMessages.phone') }} </label>
            <p class="form-control" style="height: auto">{{$visitorMessage->phone}}</p>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('address', $lang) ?? __('visitorMessages.address') }} </label>
            <p class="form-control" style="height: auto">{{$visitorMessage->address}}</p>
        </div>
{{--        <div class="form-group col-lg-12">--}}
{{--            <label>{{ meta('subject', $lang) ?? __('visitorMessages.subject') }}</label>--}}
{{--            <p class="form-control" style="height: auto">{{$visitorMessage->subject}}</p>--}}
{{--        </div>--}}
{{--        <div class="form-group col-lg-12">--}}
{{--            <label>{{ meta('message', $lang) ?? __('visitorMessages.message') }}</label>--}}
{{--            <p class="form-control overflow-auto" style="height: 200px;">{{$visitorMessage->message}}</p>--}}
{{--        </div>--}}
        @endif
        {{-- Start replies container--}}
        @if ($replies ?? false)

            @foreach ($replies as $reply)
                    <div class="col-sm-1">
                        <div class="thumbnail">
                            <img class="img-responsive rounded img-thumbnail user_photo" src="{{getUser($reply->user_id)->photo ? asset(getUser($reply->user_id)->photo) : asset('assets/admin/images/reply_avatar.png')}}">
                        </div>
                    </div>
                    <div class="card col-sm-11 reply_card mb-2">
                        <div class="card-header d-flex justify-content-between">
                            <strong>{{getUser($reply->user_id)->name}}</strong> <span class="bg-dark text-white rounded px-1"><i class="fa fa-user-clock"></i> {{$reply->created_at}}</span>
                        </div>
                        <div class="card-body">
                            {!! $reply->reply !!}
                        </div>
                    </div>
            @endforeach

        @endif
        {{-- End replies container--}}

            <div class="card col-md-12 mt-3">
                <div class="card-header">
                    <div class="card-title">
                        <h4>{{meta('reply', $lang) ?? 'Replying on message'}}</h4>
                    </div>
                </div>

                <div class="card-body">
                    <div class="form-group col-lg-12">
                        <label>{{ meta('send_to', $lang) ?? __('visitorMessages.send_to') }} </label>
                        <input type="text" name="visitor_email" class="form-control {{ $errors->has('visitor_email') ? 'is-invalid' : '' }}" placeholder="{{ __('visitorMessages.email') }}" value="{{ old("email", $visitorMessage->email ?? "") }}">
                    </div>
                    <div class="form-group col-lg-12">
                        <label>{{ meta('message', $lang) ??  __('visitorMessages.message') }} </label>
                        <textarea name="reply" class="form-control my-editor" placeholder="{{ __('visitorMessages.message') }}">{{ old("message") }}</textarea>
                    </div>
                </div>
            </div>

        <div class="text-center mt-5 col-12">
            <button class="butn add_reply_button"><span>{{ __('dashboard.send') }}</span></button>
        </div>

    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_reply_button', '.add_reply_form')
    </script>

@endsection
