@foreach($users as $key=> $row)
@if (auth()->user()->role == 'super_admin' && $row->role == 'super_admin' && auth()->user()->id != 1 && auth()->user()->id != $row->id)
    @continue
@endif
<tr>
    <th scope="row">
        @if ($row->role == 'sub_admin')
            @if (auth()->user()->id != $row->id)
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input selectOne deleteCheck" id="customCheck{{$row->id}}" value="{{$row->id}}" name="id[]">
                    <label class="custom-control-label" for="customCheck{{$row->id}}"></label>
                </div>
            @endif
        @endif

    </th>
    <td>{{ $row->name }}</td>
    <td>{{ $row->email }}</td>
    <td>{{ __('users.'.$row->role) }}</td>
    <td colspan="2">{{ \Carbon\Carbon::parse($row->created_at)->format('Y/m/d') }}</td>
    <td>
        @if($row->role == 'super_admin' && $row->id == 1)
            <a href="{{ route ('users.edit', $row->id) }}" class="icon" title="{{ __('dashboard.edit') }}"><img src="{{ asset('assets/admin/images/icons/draw.svg') }}" alt="{{ __('dashboard.edit') }}"></a>
        @else

            @if($row->deleted_at)
                @if($row->role == 'sub_admin' || (auth()->user()->role == 'super_admin' && $row->role == 'super_admin' && $row->id != 1))
                    <a href="{{ route ('users.restore', $row->id) }}" data-method="put" class="icon rowAction" title="{{ __('dashboard.restore') }}"><img src="{{ asset('assets/admin/images/icons/restore.svg') }}" alt="{{ __('dashboard.restore') }}"></a>
                    @if (auth()->user()->id != $row->id)
                        <a href="{{ route ('users.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.delete') }}"><img src="{{ asset('assets/admin/images/icons/close.svg') }}" alt="{{ __('dashboard.delete') }}"></a>
                    @endif
                @endif

            @else
                <a href="{{ route ('users.edit', $row->id) }}" class="icon" title="{{ __('dashboard.edit') }}"><img src="{{ asset('assets/admin/images/icons/draw.svg') }}" alt="{{ __('dashboard.edit') }}"></a>
                @if($row->role == 'sub_admin' || (auth()->user()->role == 'super_admin' && $row->role == 'super_admin' && $row->id != 1))
                    @if (auth()->user()->id != $row->id)
                        <a href="{{ route ('users.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.trash') }}"><img src="{{ asset('assets/admin/images/icons/del.svg') }}" alt="{{ __('dashboard.trash') }}"></a>
                    @endif
                @endif
            @endif
        @endif
    </td>
</tr>
@endforeach

@if( count( $users ) && $users->hasPages() )
<tr> <td></td><td> {{ $users->links() }} </td> </tr>
@endif
