<div class="border-item">
    <form class="form-row site_settings_form" method="post" action="{{ $settingsAction }}" enctype="multipart/form-data">
        @if ($settings)
            <input type="hidden" name="update" value="true">
        @endif
        @csrf

        @if (auth()->user()->role == 'super_admin')
            <div class="col-md-12">
                <div class="card mb-5">
                    <div class="card-header">
                        <h4>{{__('settings.disable_dashboard_and_site')}}</h4>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <i class="fas fa-globe"></i> <b>{{meta('website_disable', $lang) ?? 'Website Disabled'}}</b>
                            <label class="switch ">
                                <input {{$settings->website_disable == 1 ? 'checked' : ''}} type="checkbox" class="success" name="website_disable" value="1">
                                <span class="slider"></span>
                            </label>
                        </li>
                        <li class="list-group-item">
                            <i class="fas fa-chart-line"></i> <b> {{ meta('dashboard_disable', $lang) ?? 'Dashboard Disabled' }}</b>
                            <label class="switch ">
                                <input {{$settings->dashboard_disable == 1 ? 'checked' : ''}} type="checkbox" class="success" name="dashboard_disable" value="1">
                                <span class="slider"></span>
                            </label>
                        </li>
                    </ul>
                </div>
            </div>
        @endif
            <ul class="nav nav-tabs col-lg-12" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="home-tab" data-toggle="tab" data-target="#general_settings" type="button" role="tab" aria-controls="home" aria-selected="true">{{__('settings.general_settings')}}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="profile-tab" data-toggle="tab" data-target="#social_settings" type="button" role="tab" aria-controls="profile" aria-selected="false">{{__('settings.social_settings')}}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="contact-tab" data-toggle="tab" data-target="#other_settings" type="button" role="tab" aria-controls="contact" aria-selected="false">{{__('settings.other_settings')}}</button>
                </li>
            </ul>
            <div class="tab-content col-lg-12" id="myTabContent">
                {{-- General settings block--}}
                <div class="tab-pane fade show active" id="general_settings" role="tabpanel" aria-labelledby="home-tab">
                    <div class="row pt-4">
                        @foreach(languages() as $language)
                            <div class="form-group col-lg-6">
                                <label>{{ meta('website_name', $language->local) ?? __('articles.website_name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                                <input type="text" class="form-control {{ $errors->has('website_name_'.$language->local) ? 'is-invalid' : '' }}" name="website_name_{{ $language->local }}" placeholder="{{ meta('website_name', $language->local) ?? __('articles.website_name') }}" value='{{ old("website_name_{$language->local}", $settings->{'website_name_'.$language->local} ?? "") }}'/>
                            </div>
                            <div class="form-group col-lg-6">
                                <label>{{ meta('site_address', $language->local) ?? __('articles.site_address') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                                <input type="text" class="form-control {{ $errors->has('site_address_'.$language->local) ? 'is-invalid' : '' }}" name="site_address_{{ $language->local }}" placeholder="{{ meta('site_address', $language->local) ?? __('articles.site_address') }}" value='{{ old("site_address_{$language->local}", $settings->{'site_address_'.$language->local} ?? "") }}'/>
                            </div>

                            <div class="form-group col-lg-6">
                                <label>{{ meta('Keywords', $language->local) ?? __('articles.Keywords') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                                <input type="text" class="form-control {{ $errors->has('Keywords_'.$language->local) ? 'is-invalid' : '' }}" name="Keywords_{{ $language->local }}" placeholder="{{ meta('Keywords', $language->local) ?? __('articles.Keywords') }}" value='{{ old("Keywords_{$language->local}", $settings->{'keywords_'.$language->local} ?? "") }}'/>
                            </div>
                            <div class="form-group col-lg-6">
                                <label>{{ meta('meta_description', $language->local) ?? __('articles.meta_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                                <input type="text" class="form-control {{ $errors->has('meta_description_'.$language->local) ? 'is-invalid' : '' }}" name="meta_description_{{ $language->local }}" placeholder="{{ meta('meta_description', $language->local) ?? __('articles.meta_description') }}" value='{{ old("meta_description_{$language->local}", $settings->{'meta_description_'.$language->local} ?? "") }}'/>
                            </div>

                            <div class="form-group col-lg-6">
                                <label>{{ meta('meta_description', $language->local) ?? __('articles.meta_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                                <input type="text" class="form-control {{ $errors->has('meta_description_'.$language->local) ? 'is-invalid' : '' }}" name="meta_description_{{ $language->local }}" placeholder="{{ meta('meta_description', $language->local) ?? __('articles.meta_description') }}" value='{{ old("meta_description_{$language->local}", $settings->{'meta_description_'.$language->local} ?? "") }}'/>
                            </div>
                        @endforeach
                        <div class="form-group col-lg-6">
                            <label>{{ meta('site_email', $lang) ?? __('settings.site_email') }}</label>
                            <input type="email" class="form-control {{ $errors->has('site_email') ? 'is-invalid' : '' }}" name="site_email" placeholder="{{ meta('site_email', $lang) ?? __('settings.site_email') }}" value='{{ old("site_email", $settings->site_email ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                                <label>{{ meta('site_phone', $lang) ?? __('settings.site_phone') }}</label>
                                <input type="tel" class="form-control {{ $errors->has('site_phone') ? 'is-invalid' : '' }}" name="site_phone" placeholder="{{ meta('site_phone', $lang) ?? __('settings.site_phone') }}" value='{{ old("site_phone", $settings->site_phone ?? "") }}'/>
                            </div>
                            {{--        <div class="form-group col-lg-6">--}}
                            {{--            <label>{{ meta('site_tel', $lang) ?? __('settings.site_tel') }}</label>--}}
                            {{--            <input type="tel" class="form-control {{ $errors->has('site_tel') ? 'is-invalid' : '' }}" name="site_tel" placeholder="{{ meta('site_tel', $lang) ?? __('settings.site_tel') }}" value='{{ old("site_tel", $settings->site_tel ?? "") }}'/>--}}
                            {{--        </div>--}}
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_driver', $lang) ?? __('settings.mail_driver') }}</label>
                            <input type="text" class="form-control {{ $errors->has('mail_driver') ? 'is-invalid' : '' }}" name="mail_driver" placeholder="{{ meta('mail_driver', $lang) ?? __('settings.mail_driver') }}" value='{{ old("mail_driver", $settings->mail_driver ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_host', $lang) ?? __('settings.mail_host') }}</label>
                            <input type="text" class="form-control {{ $errors->has('mail_host') ? 'is-invalid' : '' }}" name="mail_host" placeholder="{{ meta('mail_host', $lang) ?? __('settings.mail_host') }}" value='{{ old("mail_host", $settings->mail_host ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_port', $lang) ?? __('settings.mail_port') }}</label>
                            <input type="number" class="form-control {{ $errors->has('mail_port') ? 'is-invalid' : '' }}" name="mail_port" placeholder="{{ meta('mail_port', $lang) ?? __('settings.mail_port') }}" value='{{ old("mail_port", $settings->mail_port ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_username', $lang) ?? __('settings.mail_username') }}</label>
                            <input type="text" class="form-control {{ $errors->has('mail_username') ? 'is-invalid' : '' }}" name="mail_username" placeholder="{{ meta('mail_username', $lang) ?? __('settings.mail_username') }}" value='{{ old("mail_username", $settings->mail_username ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_password', $lang) ?? __('settings.mail_password') }}</label>
                            <input type="password" class="form-control {{ $errors->has('mail_password') ? 'is-invalid' : '' }}" name="mail_password" placeholder="{{ meta('mail_password', $lang) ?? __('settings.mail_password') }}" value='{{ old("mail_password", $settings->mail_password ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_encryption', $lang) ?? __('settings.mail_encryption') }}</label>
                            <input type="text" class="form-control {{ $errors->has('mail_encryption') ? 'is-invalid' : '' }}" name="mail_encryption" placeholder="{{ meta('mail_encryption', $lang) ?? __('settings.mail_encryption') }}" value='{{ old("mail_encryption", $settings->mail_encryption ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_from_address', $lang) ?? __('settings.mail_from_address') }}</label>
                            <input type="text" class="form-control {{ $errors->has('mail_from_address') ? 'is-invalid' : '' }}" name="mail_from_address" placeholder="{{ meta('mail_from_address', $lang) ?? __('settings.mail_from_address') }}" value='{{ old("mail_from_address", $settings->mail_from_address ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>{{ meta('mail_from_name', $lang) ?? __('settings.mail_from_name') }}</label>
                            <input type="text" class="form-control {{ $errors->has('mail_from_name') ? 'is-invalid' : '' }}" name="mail_from_name" placeholder="{{ meta('mail_from_name', $lang) ?? __('settings.mail_from_name') }}" value='{{ old("mail_from_name", $settings->mail_from_name ?? "") }}'/>
                        </div>
                        {{--Start image container--}}
                        <div class="form-group col-lg-12">
                            <label>{{ meta('website_logo', $lang) ?? __('settings.website_logo') }} </label>
                            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="website_logo" value="{{old("website_logo", $settings->website_logo ?? "")}}"/>

                            <div class="photos main_photo {{ old('website_logo', $settings->website_logo ?? '') ? ' wow fadeInUp' : 'hide' }}">
                                <div class="col-lg-4">
                                    <div class="items">
                                        <div class="img">
                                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                                <img src="{{asset(old('website_logo', $settings->website_logo ?? ''))}} "  id="image_holder" class="image_holder"/>
                                            </a>
                                        </div>
                                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <span class="input-group-btn pick_button {{ old('website_logo', $settings->website_logo ?? '') ? 'hide' : '' }} ">
            <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
            </a>
        </span>
                        </div>
                        {{--End image container--}}
                    </div>
                </div>
                {{-- Social settings block--}}
                <div class="tab-pane fade" id="social_settings" role="tabpanel" aria-labelledby="home-tab">
                    <div class="row pt-4">
                        <div class="form-group col-lg-12">
                            <label>{{ meta('facebook', $lang) ?? __('settings.facebook') }}</label>
                            <input type="text" class="form-control {{ $errors->has('facebook') ? 'is-invalid' : '' }}" name="facebook" placeholder="{{ meta('facebook', $lang) ?? __('settings.facebook') }}" value='{{ old("facebook", $settings->facebook ?? "") }}'/>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>{{ meta('twitter', $lang) ?? __('settings.twitter') }}</label>
                            <input type="text" class="form-control {{ $errors->has('twitter') ? 'is-invalid' : '' }}" name="twitter" placeholder="{{ meta('twitter', $lang) ?? __('settings.twitter') }}" value='{{ old("twitter", $settings->twitter ?? "") }}'/>
                        </div>
                        {{--            <div class="form-group col-lg-12">--}}
                        {{--                <label>{{ meta('instagram', $lang) ?? __('settings.instagram') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('instagram') ? 'is-invalid' : '' }}" name="instagram" placeholder="{{ meta('instagram', $lang) ?? __('settings.instagram') }}" value='{{ old("instagram", $settings->instagram ?? "") }}'/>--}}
                        {{--            </div>--}}
                        {{--            <div class="form-group col-lg-12">--}}
                        {{--                <label>{{ meta('whatsapp', $lang) ?? __('settings.whatsapp') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('whatsapp') ? 'is-invalid' : '' }}" name="whatsapp" placeholder="{{ meta('whatsapp', $lang) ?? __('settings.whatsapp') }}" value='{{ old("whatsapp", $settings->whatsapp ?? "") }}'/>--}}
                        {{--            </div>--}}
                        <div class="form-group col-lg-12">
                            <label>{{ meta('linkedin', $lang) ?? __('settings.linkedin') }}</label>
                            <input type="text" class="form-control {{ $errors->has('linkedin') ? 'is-invalid' : '' }}" name="linkedin" placeholder="{{ meta('linkedin', $lang) ?? __('settings.linkedin') }}" value='{{ old("linkedin", $settings->linkedin ?? "") }}'/>
                        </div>
                        {{--            <div class="form-group col-lg-12">--}}
                        {{--                <label>{{ meta('snapchat', $lang) ?? __('settings.snapchat') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('snapchat') ? 'is-invalid' : '' }}" name="snapchat" placeholder="{{ meta('snapchat', $lang) ?? __('settings.snapchat') }}" value='{{ old("snapchat", $settings->snapchat ?? "") }}'/>--}}
                        {{--            </div>--}}
                    </div>
                </div>
                {{-- Other settings block--}}
                <div class="tab-pane fade" id="other_settings" role="tabpanel" aria-labelledby="contact-tab">
                    <div class="row pt-4">
                        {{--            <div class="form-group col-lg-12">--}}
                        {{--                <label>{{ meta('site_map', $lang) ?? __('settings.site_map') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('site_map') ? 'is-invalid' : '' }}" name="site_map" placeholder="{{ meta('site_map', $lang) ?? __('settings.site_map') }}" value='{{ old("site_map", $settings->site_map ?? "") }}'/>--}}
                        {{--            </div>--}}

                        <div class="form-group col-lg-12">
                            <label>{{ meta('google_play_link', $lang) ?? __('settings.google_play_link') }}</label>
                            <input type="text" class="form-control {{ $errors->has('google_play_link') ? 'is-invalid' : '' }}" name="google_play_link" placeholder="{{ meta('google_play_link', $lang) ?? __('settings.google_play_link') }}" value='{{ old("google_play_link", $settings->google_play_link ?? "") }}'/>
                        </div>
                        {{--            <div class="form-group col-lg-12">--}}
                        {{--                <label>{{ meta('android_version', $lang) ?? __('settings.android_version') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('android_version') ? 'is-invalid' : '' }}" name="android_version" placeholder="{{ meta('android_version', $lang) ?? __('settings.android_version') }}" value='{{ old("android_version", $settings->android_version ?? "") }}'/>--}}
                        {{--            </div>--}}
                        <div class="form-group col-lg-12">
                            <label>{{ meta('apple_store_link', $lang) ?? __('settings.apple_store_link') }}</label>
                            <input type="text" class="form-control {{ $errors->has('apple_store_link') ? 'is-invalid' : '' }}" name="apple_store_link" placeholder="{{ meta('apple_store_link', $lang) ?? __('settings.apple_store_link') }}" value='{{ old("apple_store_link", $settings->apple_store_link ?? "") }}'/>
                        </div>

                        {{--            <div class="form-group col-lg-12">--}}
                        {{--                <label>{{ meta('ios_version', $lang) ?? __('settings.ios_version') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('ios_version') ? 'is-invalid' : '' }}" name="ios_version" placeholder="{{ meta('ios_version', $lang) ?? __('settings.ios_version') }}" value='{{ old("ios_version", $settings->ios_version ?? "") }}'/>--}}
                        {{--            </div>--}}
                        {{--            <div class="form-group col-lg-6">--}}
                        {{--                <label>{{ meta('tiktok', $lang) ?? __('settings.tiktok') }}</label>--}}
                        {{--                <input type="text" class="form-control {{ $errors->has('tiktok') ? 'is-invalid' : '' }}" name="tiktok" placeholder="{{ meta('tiktok', $lang) ?? __('settings.tiktok') }}" value='{{ old("tiktok", $settings->tiktok ?? "") }}'/>--}}
                        {{--            </div>--}}
                    </div>
                </div>
            </div>

        <div class="text-center mt-5 col-12">
            <button class="butn site_settings_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>
