@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($page ?? ''  && $page->id)
            @method('PUT')
        @endif
        @CSRF

        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('page_title', $language->local) ?? __('pages.page_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('page_title_'.$language->local) ? 'is-invalid' : '' }}" name="page_title_{{ $language->local }}" placeholder="{{ meta('page_title', $language->local) ?? __('pages.page_title') }}" value='{{ old("page_title_{$language->local}", $page[$language->local]->page_title ?? null) }}'/>
        </div>

        @if(($page[$language->local]->title ?? null) && !is_array($page[$language->local]->title ?? null))
            <div class="form-group col-lg-12">
                <label>{{ meta('title', $language->local) ?? __('pages.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('pages.title') }}" value='{{ old("title_{$language->local}", $page[$language->local]->title ?? null) }}'/>
            </div>
        @endif
        @if(is_array($page[$language->local]->title ?? []) && count($page[$language->local]->title ?? []))
            @foreach($page[$language->local]->title as $titles)
                <div class="form-group col-lg-6">
                    <label>{{ (meta('title', $language->local) ?? __('pages.title')) . ' ' . $loop->iteration }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('pages.title') }}" value='{{ old("title_{$language->local}", $titles ?? null) }}'/>
                </div>
            @endforeach
        @endif

        @if(($page[$language->local]->description ?? null) && !is_array($page[$language->local]->description ?? null))
            <div class="form-group col-lg-12">
                <label>{{ meta('description', $language->local) ?? __('pages.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea id="description_{{ $language->local }}" name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{{ old("description_{$language->local}", $page[$language->local]->description ?? null) }}</textarea>
            </div>
        @endif

        @if(is_array($page[$language->local]->description ?? []) && count($page[$language->local]->description ?? []))
            @if($page->id == 14)
                @foreach($page[$language->local]->description['titles'] as $titleKey => $titles)
                    <div class="form-group col-lg-12">
                        <label>{{ (meta('title', $language->local) ?? __('pages.title')) . ' ' . $loop->iteration }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('pages.title') }}" value='{{ old("title_{$language->local}", $titles ?? null) }}'/>
                    </div>
                    <div class="form-group col-lg-12">
                        <label>{{ (meta('description', $language->local) ?? __('pages.description')) . ' ' . $loop->iteration }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <textarea id="description_{{ $language->local }}" name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{{ old("description_{$language->local}", $page[$language->local]->description['descriptions'][$titleKey] ?? null) }}</textarea>
                    </div>
                @endforeach
                @else
                @foreach($page[$language->local]->description as $descriptions)
                    <div class="form-group col-lg-12">
                        <label>{{ (meta('description', $language->local) ?? __('pages.description')) . ' ' . $loop->iteration }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <textarea id="description_{{ $language->local }}" name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{{ old("description_{$language->local}", $descriptions ?? null) }}</textarea>
                    </div>
                @endforeach
            @endif
        @endif

        @if(is_array($page[$language->local]->other_details ?? []) && count($page[$language->local]->other_details ?? []))
               @if($page[$language->local]->other_details['titles'] ?? null)
                   @foreach($page[$language->local]->other_details['titles'] as $titles)
                       <div class="form-group col-lg-6">
                           <label>{{ (meta('title', $language->local) ?? __('pages.title')) . ' ' . $loop->iteration }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                           <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('pages.title') }}" value='{{ old("title_{$language->local}", $titles ?? null) }}'/>
                       </div>
                   @endforeach

               @endif
               @if($page[$language->local]->other_details['descriptions'] ?? null)
                       @foreach($page[$language->local]->other_details['descriptions'] as $descriptions)
                       <div class="form-group col-lg-12">
                           <label>{{ (meta('description', $language->local) ?? __('pages.description')) . ' ' . $loop->iteration }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                           <textarea id="description_{{ $language->local }}" name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{{ old("description_{$language->local}", $descriptions ?? null) }}</textarea>
                       </div>
                   @endforeach
               @endif
        @endif
        @endforeach

        @if($page->id == 1)
        <div class="row">
            @foreach($page->meta['numbers'] as $numbers)
                <div class="form-group col-lg-4">
                    <label>{{ (meta('numbers', $lang) ?? __('pages.numbers')) . ' (' . $loop->iteration . ')' }} </label>
                    <input type="text" class="form-control {{ $errors->has('numbers') ? 'is-invalid' : '' }}" name="numbers[]" placeholder="{{ meta('numbers', $lang) ?? __('pages.numbers') }}" value='{{ old("numbers", $numbers ?? null) }}'/>
                </div>
            @endforeach
        </div>
        @endif

        @if($page->id == 2)
            <div class="row">
                @foreach($page->meta['years'] as $years)
                    <div class="form-group col-lg-4">
                        <label>{{ (meta('years', $lang) ?? __('pages.years')) . ' (' . $loop->iteration . ')' }} </label>
                        <input type="text" class="form-control {{ $errors->has('`years`') ? 'is-invalid' : '' }}" name="`years`[]" placeholder="{{ meta('years', $lang) ?? __('pages.years') }}" value='{{ old("years", $years ?? null) }}'/>
                    </div>
                @endforeach
            </div>
        @endif

        @if($page->id == 21)
            <div class="form-group video_url col-lg-12">
                <label>{{ meta('video_url', $lang) ?? __('pages.video_url') }} </label>
                <input type="url" class="form-control {{ $errors->has('video_url') ? 'is-invalid' : '' }}" name="video_url" placeholder="{{ meta('video_url', $lang) ?? __('pages.video_url') }}" value='{{ old("video_url", $page->meta['video_url'] ?? null) }}'/>
            </div>
        @endif


        {{--Start image container--}}
        @if(in_array($page->id, [4,6,8,9,10,13,14,15,16,18,21]))
            <div class="form-group col-lg-12">
                <label>{{ meta('image', $lang) ?? __('pages.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $page->image ?? "")}}"/>

                <div class="photos image_main_photo {{ old('image', $page->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".image_pick_button">
                                    <img src="{{asset(old('image', $page->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".image_main_photo" data-show=".image_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn image_pick_button {{ old('image', $page->image ?? '') ? 'hide' : '' }} ">
                    <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".image_main_photo" data-hide=".image_pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                    </a>
                </span>
            </div>

        @endif
        @if (is_array($page->images ?? []) && count($page->images ?? []))
            <div class="border-item photos col-md-12 other_image_container">
                <div class="row">
                    @foreach ($page->images as $image)
                        <div class="col-md-4">
                            <div class="items">
                                <div class="img">
                                    <a href="{{ asset($image ?? null)}}" data-fancybox="gallery"><img src="{{ asset($image ?? null)}}" alt=""></a>
                                </div>
                                <input type="hidden" name="images[]" value="{{ $image ?? null }}">
                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="text-center">
                    <input id="other_image_thumbnail" class="other_image_thumbnail" type="hidden"/>
                    <div class="clearfix"></div>
                    <span id="add">
                <a id="lfm" data-width="" data-cache="article_gallery" data-input=".other_image_thumbnail" data-preview="" data-show="" data-hide="" class="lfm add">
                    {{__('dashboard.add_new_item')}}
                </a>
            </span>
                </div>
            </div>
        @endif
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{-- <script src="//cdn.tinymce.com/4/tinymce.min.js"></script> --}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            videoPath = "{{asset('assets/web/images/icons/video.png')}}",
            inputName = null;
        let imgSrc = "{{asset('assets/admin/images/file-icon.png')}}";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>


    <script>

        sendAjax('.add_button', '.add_form');

        $('select[name="video_added_type"]').change(function () {

            let thisVal = $(this).val();

            if(thisVal === 'video'){
                $('.video_container').removeClass('d-none');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

            if(thisVal === 'url'){
                $('.video_url').removeClass('d-none');
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
            }

            if(!thisVal){
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

        });

        $('.add_properties').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let serviceDiv = `
                <div class="form-group col-lg-12 card deleted_property property_card">
                    <label>{{ __('pages.properties') }}</label>
                   <div class="row">
                   <div class="form-group col-md-12 d-flex justify-content-end">
                   <a href="#" class="btn btn-danger delete_property mr-3"><i class="fa fa-times"></i></a>
                   </div>
                    @foreach($languages as $language)
                        <div class="form-group col-md-12">
                            <input type="text" name="properties_{{$language->local}}[]" placeholder="{{__('pages.property_title') . ' ' . "($language->name)"}}" class="form-control" value=""/>
                        </div>
                    @endforeach

                </div>`;

            $('.property_container').append(serviceDiv);

        });

        $(document).on('click', '.delete_property', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_property').remove();
        });

        $('body').on('DOMNodeInserted', '.properties_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });

    </script>

@endsection



