@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? ''}}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($gallery ?? ''  && $gallery->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col">
            <label>{{ meta('type', $lang) ?? __('galleries.type') }} </label>
            <select name="type" class="form-control {{ $errors->has('type') ? 'is-invalid' : '' }}">
                <option {{old('type', $gallery->type ?? null) == 'image_type' ? 'selected' : '' }} value="image_type">{{__('galleries.image_type')}}</option>
                <option {{old('type', $gallery->type ?? null) == 'video_type' ? 'selected' : '' }} value="video_type">{{__('galleries.video_type')}}</option>
            </select>
        </div>

{{--        <div class="form-group col-lg-6">--}}
{{--            <label>{{ meta('category_id', $lang) ?? __('galleries.category_id') }} </label>--}}
{{--            <select name="category_id" class="form-control {{ $errors->has('category_id') ? 'is-invalid' : '' }}">--}}
{{--                @if(count($categories))--}}
{{--                    @foreach($categories as $category)--}}
{{--                        <option {{old('category_id', $gallery->category_id ?? null) == $category->id ? 'selected' : '' }} value="{{$category->id}}">{{$category->name}}</option>--}}
{{--                    @endforeach--}}
{{--                @endif--}}
{{--            </select>--}}
{{--        </div>--}}
            <div class="form-group col-lg-6 video_added_type {{($gallery->type ?? null) == 'video_type' ? '' : 'd-none'}}">
                <label>{{ meta('video_added_type', $lang) ?? __('galleries.video_added_type') }} </label>
                <select name="video_added_type" class="form-control {{ $errors->has('video_added_type') ? 'is-invalid' : '' }}">
                    <option value="">{{__('galleries.video_added_type')}}</option>
                    <option {{($gallery->video_url ?? null) ? 'selected' : '' }} value="url">{{__('galleries.url')}}</option>
                    <option {{($gallery->video ?? null) ? 'selected' : '' }} value="video">{{__('galleries.video')}}</option>
                </select>
            </div>
        <div class="form-group video_url col-lg-12 {{($gallery->video_url ?? null) ? '' : 'd-none'}}">
            <label>{{ meta('video_url', $lang) ?? __('galleries.video_url') }} </label>
            <input type="url" class="form-control {{ $errors->has('video_url') ? 'is-invalid' : '' }}" name="video_url" placeholder="{{ meta('video_url', $lang) ?? __('galleries.video_url') }}" value='{{ old("video_url", $gallery->video_url ?? null) }}'/>
        </div>

        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('title', $language->local) ?? __('galleries.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('galleries.title') }}" value='{{ old("title_{$language->local}", $gallery[$language->local]->title ?? null) }}'/>
        </div>
        @endforeach

        {{--Start image container--}}
        <div class="form-group col-lg-6">
            <label>{{ meta('image', getCurrentLocale()) ?? __('galleries.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $gallery->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $gallery->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-12">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('image', $gallery->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $gallery->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
            </span>
        </div>
        {{--End image container--}}

            {{--Start video container--}}
            <div class="form-group col-lg-6 video_container {{($gallery->video ?? null) ? '' : 'd-none'}}">
                <label>{{ meta('video', getCurrentLocale()) ?? __('galleries.video') }} </label>
                <input id="video_thumbnail" class="video_thumbnail" type="hidden" name="video" value="{{old("video", $gallery->video ?? "")}}"/>

                <div class="photos main_video {{ old('video', $gallery->video ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".video_thumbnail" data-preview=".video_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset('assets/web/images/icons/video.png')}}"  id="video_holder" class="video_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".video_thumbnail" data-hide=".main_video" data-show=".video_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn video_pick_button {{ old('video', $gallery->video ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".video_thumbnail" data-preview=".video_holder" data-show=".main_video" data-hide=".video_pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
            </span>
            </div>
            {{--End video container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            videoPath = "{{asset('assets/web/images/icons/video.png')}}",
            inputName = null;
        let imgSrc = "{{asset('assets/admin/images/file-icon.png')}}";
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script>


        sendAjax('.add_button', '.add_form');

        $('select[name="type"]').change(function () {

            let thisVal = $(this).val();

            if(thisVal === 'image_type'){
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
                $('.video_added_type').addClass('d-none');
                $('select[name="video_added_type"]').val(null);
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
            }

            if(thisVal === 'video_type'){
                $('.video_url').removeClass('d-none');
                $('.video_added_type').removeClass('d-none')
            }

            $('.video_url').addClass('d-none');
            $('input[name="video_url"]').val(null);

        });

        $('select[name="video_added_type"]').change(function () {

            let thisVal = $(this).val();

            if(thisVal === 'video'){
                $('.video_container').removeClass('d-none');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

            if(thisVal === 'url'){
                $('.video_url').removeClass('d-none');
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
            }

            if(!thisVal){
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

        });

        {{--let getCategoriesRoute = "{{route('galleries.getCategories')}}",--}}
        {{--    selectTypeTitle = "{{__('galleries.category_id')}}";--}}

        {{--$('select[name="type"]').change(async function(){--}}

        {{--    let categorySelector = $('select[name="category_id"]');--}}

        {{--    categorySelector.html(`<option value="">${selectTypeTitle}</option>`);--}}

        {{--    let typeVal = $(this).val();--}}

        {{--    let data = {type: typeVal},--}}
        {{--        url = getCategoriesRoute,--}}
        {{--        method = 'get';--}}

        {{--    const response=await ajax({--}}
        {{--        url,--}}
        {{--        data,--}}
        {{--        dataType: 'json',--}}
        {{--        method--}}
        {{--    });--}}

        {{--    if (response.url){--}}
        {{--        window.location.href = response.url;--}}
        {{--    }--}}

        {{--    if (response.categories.length){--}}
        {{--        categorySelector.html('');--}}

        {{--        for(let cat of response.categories){--}}
        {{--            categorySelector.append(`<option value="${cat.id}">${cat.name}</option>`)--}}
        {{--        }--}}
        {{--        if(typeVal === 'video_type'){--}}
        {{--            $('.video_url').removeClass('d-none');--}}
        {{--            $('.title_container').removeClass('d-none');--}}
        {{--        } else {--}}
        {{--            $('.video_url').addClass('d-none');--}}
        {{--            $('input[name="video_url"]').val('');--}}
        {{--            $('.title_container').addClass('d-none');--}}
        {{--            $('.title_container input').val(null);--}}
        {{--        }--}}

        {{--    }--}}


        {{--});--}}


    </script>
@endsection



