@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($career ?? ''  && $career->id)
            @method('PUT')
        @endif
        @csrf

            <div class="form-group col-lg-12">
                <label>{{ meta('category_id', $lang) ?? __('careers.category_id') }} </label>
                <select name="category_id" class="form-control {{ $errors->has('category_id') ? 'is-invalid' : '' }}">
                    @if(count($categories))
                        @foreach($categories as $category)
                            <option {{old('category_id', $career->category_id ?? null) == $category->id ? 'selected' : '' }} value="{{$category->id}}">{{$category->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>

            @foreach(languages() as $language)
{{--                <div class="form-group col-lg-6">--}}
{{--                    <label>{{ meta('type', $language->local) ?? __('careers.type') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <input type="text" class="form-control {{ $errors->has('type_'.$language->local) ? 'is-invalid' : '' }}" name="type_{{ $language->local }}" placeholder="{{ meta('type', $language->local) ?? __('careers.type') }}" value='{{ old("type_{$language->local}", $career[$language->local]->type ?? "") }}'/>--}}
{{--                </div>--}}
                <div class="form-group col-lg-12">
                    <label>{{ meta('name', $language->local) ?? __('careers.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('careers.name') }}" value='{{ old("name_{$language->local}", $career[$language->local]->name ?? "") }}'/>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('career_description', $language->local) ?? __('careers.career_description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="career_description_{{ $language->local }}" id="career_description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('career_description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('career_description', $language->local) ?? __('careers.career_description')}}">{{ old("career_description_{$language->local}", $career[$language->local]->career_description ?? "") }}</textarea>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('mini_qualifications', $language->local) ?? __('careers.mini_qualifications')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="mini_qualifications_{{ $language->local }}" id="mini_qualifications_{{ $language->local }}" class="form-control my-editor {{ $errors->has('mini_qualifications_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('mini_qualifications', $language->local) ?? __('careers.mini_qualifications')}}">{{ old("mini_qualifications_{$language->local}", $career[$language->local]->mini_qualifications ?? "") }}</textarea>
                </div>
            @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('careers.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $career->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $career->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $career->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $career->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

@endsection



