/**
 * Contact us block
 */
$('.contact_us_button').click(async function (e) {
    e.preventDefault();

    $(this).prop('disabled', true);

    let form = $('.contact_us_form'),
        data = new FormData(form[0]),
        url = form.attr('action'),
        method = form.attr('method');

    const response=await ajax({
        url,
        data,
        dataType: 'json',
        method
    });

    if (response.errors){
        $(this).prop('disabled', false);
        toasterError(response.errors);
    }

    if (response.message){
        toasterSuccess(response.message);
        $('input, textarea').val('');
    }

});


/**
 * Branches & rooms block
 */

$('.branch_button').click(async function (e) {
    e.preventDefault();

    $(this).prop('disabled', true);

    let roomContainer = $('.room_container'),
        roomsTypesContainer = $('.rooms_types_container');
    roomContainer.html('');
    roomsTypesContainer.html('');

    let data = {branch_id: $(this).data('branch')},
        url = getRoomsAndRoomTypeRoute,
        method = 'get';

    const response=await ajax({
        url,
        data,
        dataType: 'json',
        method
    });

    if (response){
        $(this).attr('disabled', false);
        roomContainer.html('');
        roomsTypesContainer.html(response);
        if (response.search('room_items_container') > -1){
            $('.room_container').html(`<div style="background-color: #cd9b39" class="alert text-center col-md-12">${chooseRoomTypeTitle}</div>`)
        }
        // $('.room_type_li:first-of-type button').trigger('click');
    }

});

$(document).on('click', '.room_type_button', async function (e) {
    e.preventDefault();

    let roomContainer = $('.room_container');

    $(this).prop('disabled', true);
    roomContainer.html('');

    let data = {branch_id: $('.branch_button.active').data('branch'), room_type_id: $(this).data('room-type')},
        url = getRoomsAndRoomTypeRoute,
        method = 'get';

    const response=await ajax({
        url,
        data,
        dataType: 'json',
        method
    });

    if (response){
        $(this).attr('disabled', false);
        roomContainer.html(response);
    }

});

/**
 * Video and photo gallery block
 */


$('.category_type').click(async function (e) {
    e.preventDefault();
    let gallery_category_container = $('.gallery_category_container'),
        galleries_container = $('.galleries_container');

    gallery_category_container.html('');
    galleries_container.html('');

    $(this).prop('disabled', true);

    let data = {category_type: $(this).data('type')},
        url = getCategoryAndGalleryRout,
        method = 'get';

    const response=await ajax({
        url,
        data,
        dataType: 'json',
        method
    });

    if (response){
        $(this).attr('disabled', false);
        gallery_category_container.html(response);
        $('.gallery_category_li:first-of-type button').trigger('click');
    }

});

$(document).on('click', '.gallery_category_button', async function (e) {
    e.preventDefault();

    let galleries_container = $('.galleries_container');

    $(this).prop('disabled', true);
    galleries_container.html('');

    let data = {category_type: $('.category_type.active').data('type'), category_id: $(this).data('category')},
        url = getCategoryAndGalleryRout,
        method = 'get';

    const response=await ajax({
        url,
        data,
        dataType: 'json',
        method
    });

    if (response){
        $(this).attr('disabled', false);
        galleries_container.html(response);
    }

});




$(document).ready(function () {

    $('.map_container iframe').attr('width', '100%').attr('height', '450');

    $('.special_needs_desc_container p').addClass('p');
    $('.about_sec_desc_container p').addClass('p');
    $('.about_sec_desc_container ul').addClass('custom_ul mt-5');
    $('.about_sec_desc_container ul li').addClass('li');
});
