<?php

use Illuminate\Database\Seeder;

class SiteSliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/header-1.png',
            'assets/web/images/header-2.jpg',
        ];

        foreach ($images as $image) {
            factory(\App\SiteSlider::class)->create(['image' => $image]);
        }

        foreach (\App\SiteSlider::cursor() as $slider) {
            foreach (languages() as $language) {
                factory(\App\SiteSliderDescription::class)->create([
                    'site_slider_id' => $slider->id,
                    'language_id' => $language->id,
                ]);
            }
        }


    }
}
