<?php

use Illuminate\Database\Seeder;

class ReviewSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/feedback_1.png',
            'assets/web/images/feedback_2.png',
            'assets/web/images/header-1.png',
            'assets/web/images/about-1.png',
        ];

        foreach ($images as $image) {
            factory(\App\Review::class)->create(['image' => $image]);
        }

        foreach (\App\Review::cursor() as $review) {
            foreach (languages() as $language) {
                factory(\App\ReviewDescription::class)->create([
                    'review_id' => $review->id,
                    'language_id' => $language->id,
                ]);
            }
        }
    }
}
