<?php

use Illuminate\Database\Seeder;
use App\Module;
class ModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        Module::create(['name' => 'Categories', 'path' => 'categories', 'meta' =>
            [
                'module_name' => ['ar' => 'التصنيفات', 'en' => 'Categories'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة تصنيف جديد',
                        'edit' => 'تعديل تصنيف',
//                        'status' => 'حالة التصنيف',
                        'name' => 'إسم التصنيف',

                    ],
                    'en' => [
                        'new' => 'Add New category',
                        'edit' => 'Edit category',
//                        'status' => 'Category status',
                        'name' => 'Category name',
                    ],
                ],

            ]
        ]); // Categories **
        Module::create(['name' => 'Jobs', 'path' => 'careers', 'meta' =>
            [
                'module_name' => ['ar' => 'الوظائف', 'en' => 'Jobs'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة وظيفة جديد',
                        'edit' => 'تعديل وظيفة',
                        'category_id' => 'قسم الوظيفة',
                        'name' => 'إسم الوظيفة',
                        'image' => 'صورة الوظيفة',
                        'career_description' => 'المسمى الوظيفي',
                        'mini_qualifications' => 'الحد الأدنى من المؤهلات',

                    ],
                    'en' => [
                        'new' => 'Add New job',
                        'edit' => 'Edit job',
                        'category_id' => 'Job section',
                        'name' => 'Job name',
                        'image' => 'Job image',
                        'career_description' => 'Job Description',
                        'mini_qualifications' => 'Minimum Qualifications',

                    ],
                ],

            ]
        ]); // Careers
        Module::create(['name' => 'Jobs applications', 'path' => 'careerApplications', 'meta' =>
            [
                'module_name' => ['ar' => 'تقديمات الوظائف', 'en' => 'Jobs applications'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة تقديم جديد',
                        'edit' => 'تفاصيل التقديم',
                        'name' => 'إسم المقدم',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'الجوال',
                        'cv' => 'السيرة الذاتية',
                        'career_id' => 'إسم الوظيفة المقدم عليها',
                        'submission_date' => 'تاريخ التقديم',

                    ],
                    'en' => [
                        'new' => 'Add New job',
                        'edit' => 'Job details',
                        'name' => 'Full name',
                        'email' => 'E-mail',
                        'phone' => 'Phone',
                        'cv' => 'CV',
                        'career_id' => 'Name of the position applied for',
                        'submission_date' => 'Submission date',
                    ],
                ],

            ]
        ]); // Careers Applications
        Module::create(['name' => 'News', 'path' => 'articles', 'meta' =>
            [
                'module_name' => ['ar' => 'الأخبار', 'en' => 'News'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة خبر جديد',
                        'edit' => 'تعديل خبر',
                        'tags_ids' => 'الكلمات الدلالية',
                        'title' => 'عنوان الخبر',
                        'news_date' => 'تاريخ الخبر',
                        'news_day' => 'اليوم الخاص بالخبر',
                        'news_month' => 'الشهر الخاص بالخبر',
                        'news_year' => 'السنة الخاصة بالخبر',
                        'slug' => 'رابط Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'description' => 'الوصف',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New news',
                        'edit' => 'Edit news',
                        'tags_ids' => 'Tags',
                        'title' => 'News title',
                        'news_date' => 'News date',
                        'news_day' => 'News day',
                        'news_month' => 'news month',
                        'news_year' => 'News year',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                        'description' => 'Description',
                        'image' => 'Image',
                    ],
                ]
            ]
        ]); // Articles
        Module::create(['name' => 'Slider', 'path' => 'sliders', 'meta' =>
            [
                'module_name' => ['ar' => 'الاسلايدر', 'en' => 'Slider'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة سلايدر جديد',
                        'edit' => 'تعديل سلايدر',
                        'first_title' => 'العنوان الرئيسي',
                        'second_title' => 'العنوان الفرعي',
                        'description' => 'الوصف',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New Slider',
                        'edit' => 'Edit Slider',
                        'first_title' => 'Main title',
                        'second_title' => 'Sub title',
                        'description' => 'Description',
                        'image' => 'Image',
                    ],
                ],
            ]
        ]); // Sliders
        Module::create(['name' => 'Pages', 'path' => 'pages', 'meta' =>
            [
                'module_name' => ['ar' => 'الصفحات', 'en' => 'Pages'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة صفحة جديدة',
                        'edit' => 'تعديل صفحة',
                        'page_title' => 'عنوان الصفحة',
                        'title' => 'العنوان',
                        'description' => 'الوصف',
                        'other_details' => 'تفاصيل أخرى',
                        'image' => 'الصورة',
                        'video_url' => 'رابط الفيديو',
                        'video' => 'الفيديو',
                        'numbers' => 'الأرقام',
                        'years' => 'الأعوام',
                        'titles' => 'العناوين',
                        'descriptions' => 'الوصوف',
                    ],
                    'en' => [
                        'new' => 'Add New Page',
                        'edit' => 'Edit Pages',
                        'page_title' => 'Page title',
                        'title' => 'Title',
                        'description' => 'Description',
                        'other_details' => 'Other details',
                        'image' => 'Image',
                        'video_url' => 'Video url',
                        'video' => 'Video',
                        'numbers' => 'Numbers',
                        'years' => 'Years',
                        'titles' => 'Title',
                        'descriptions' => 'Descriptions',
                    ],
                ],

            ]
        ]); // Pages
        Module::create(['name' => 'Visitor Messages', 'path' => 'visitorMessages', 'meta' =>
            [
                'module_name' => ['ar' => 'رسائل الزوار', 'en' => 'Visitor Messages'],
                'fields' => [
                    'ar' => [
                        'new' => 'رد جديد',
//                        'name' => 'الإسم الكامل',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'الجوال',
                        'address' => 'العنوان',
//                        'subject' => 'موضوع الرسالة',
//                        'message' => 'محتوى الرسالة',
                    ],
                    'en' => [
                        'new' => 'Reply New Message',
//                        'name' => 'Name',
                        'email' => 'E-mail',
                        'phone' => 'Phone',
                        'address' => 'Address',
//                        'subject' => 'Subject',
//                        'message' => 'Message',
                    ],
                ],
            ]
        ]); // Visitor Messages
        Module::create(['name' => 'Admins', 'path' => 'users', 'meta' =>
            [
                'module_name' => ['ar' => 'المشرفين', 'en' => 'Admins'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مشرف جديد',
                        'edit' => 'تعديل مشرف',
                        'title' => 'الإسم',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'رقم الجوال',
                        'photo' => 'صورة البروفايل',
                        'password' => 'كلمة المرور',
                        'password_confirmation' => 'تأكيد كلمة المرور',
                        'modules' => 'الموديولات',
                    ],
                    'en' => [
                        'new' => 'Add New admin',
                        'edit' => 'Edit admin',
                        'name' => 'Name',
                        'email' => 'Email',
                        'phone' => 'Phone',
                        'photo' => 'Photo',
                        'password' => 'Password',
                        'password_confirmation' => 'Password Confirmation',
                        'modules' => 'Modules',
                    ],
                ],

            ]
        ]); // Users **
        Module::create(['name' => 'Settings', 'path' => 'settings', 'meta' =>
            [
                'module_name' => ['ar' => 'الإعدادت', 'en' => 'Settings'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة أعدادت',
                        'edit' => 'تعديل الإعدادت',
                        'website_disable' => 'تعطيل الموقع',
                        'disable_dashboard' => 'تعطيل لوحة التحكم',
                        'website_name' => 'اسم الموقع',
                        'Keywords' => 'الكلمات الدليلية',
                        'meta_description' => 'الكلمات الوصفية',
                        'site_email' => 'بريد الموقع',
                        'site_address' => 'عنوان الموقع',
                        'site_phone' => 'جوال الموقع',
//                        'site_tel' => 'هاتف الموقع',
                        'mail_driver' => 'Mail Driver(SMTP)',
                        'mail_host' => 'Mail Host (smtp.example.com)',
                        'mail_port' => 'Mail Port (2525)',
                        'mail_username' => 'Mail Username(username@example.cm)',
                        'mail_password' => 'Mail password',
                        'mail_encryption' => 'Mail Encryption(tls)',
                        'mail_from_address' => 'Mail From address(info@example.com)',
                        'mail_from_name' => 'Mail From Name(Example)',
                        'website_logo' => 'لوجو الموقع',
//                        'site_map' => 'خريطة الموقع',
                        'facebook' => 'فيس بوك',
                        'twitter' => 'تويتر',
//                        'instagram' => 'إنستجرام',
//                        'whatsapp' => 'واتساب',
                        'linkedin' => 'لنكدإن',
//                        'telegram' => 'تليجرام',
//                        'tiktok' => 'تيك توك',
//                        'snapchat' => 'سناب شات',
                        'google_play_link' => 'رابط التطبيق على جوجل بلاي',
                        'apple_store_link' => 'رابط التطبيق على أبل ستور',
//                        'news_start_year' => 'سنة البدء (الأخبار)',
//                        'news_end_year' => 'سنة الإنتهاء (الأخبار)',
//                        'android_version' => 'نسخة أندرويد',
//                        'ios_version' => 'نسخة أيفون',
//                        'clients_counts' => 'عدد العملاء',
//                        'reservations_sum' => 'عدد الحجوزات',
//                        'site_visits_count' => 'إجمالي زيارات الموقع',
//                        'max_room_person_count' => 'الحد الأقصى لعدد أفراد الغرف',
//                        'tax_number' => 'الرقم الضريبي',
//                        'added_value' => ' قيمة الضريبة المضافة',
                    ],
                    'en' => [
                        'new' => 'Add Settings',
                        'edit' => 'Edit Settings',
                        'website_disable' => 'Website Disabled',
                        'disable_dashboard' => 'Dashboard Disabled',
                        'website_name' => 'Website Name',
                        'Keywords' => 'Keywords',
                        'meta_description' => 'Meta Description',
                        'site_email' => 'Website Email',
                        'site_address' => 'Website Address',
                        'site_phone' => 'Website Phone',
//                        'site_tel' => 'Website tel',
                        'mail_driver' => 'Mail Driver(SMTP)',
                        'mail_host' => 'Mail Host (smtp.example.com)',
                        'mail_port' => 'Mail Port (2525)',
                        'mail_username' => 'Mail Username(username@example.cm)',
                        'mail_password' => 'Mail password',
                        'mail_encryption' => 'Mail Encryption(tls)',
                        'mail_from_address' => 'Mail From address(info@example.com)',
                        'mail_from_name' => 'Mail From Name(Example)',
                        'website_logo' => 'Website Logo',
                        'site_map' => 'Site map',
                        'facebook' => 'Facebook',
                        'twitter' => 'Twitter',
//                        'instagram' => 'Instagram',
//                        'whatsapp' => 'Whatsapp',
                        'linkedin' => 'Linkedin',
//                        'telegram' => 'Telegram',
//                        'tiktok' => 'TikTok',
//                        'snapchat' => 'Snapchat',
                        'google_play_link' => 'Google play link',
                        'apple_store_link' => 'Apple store link',
//                        'news_start_year' => 'Starting year (news)',
//                        'news_end_year' => 'Expiration year (News)',
//                        'android_version' => 'Android version',
//                        'ios_version' => 'Iphone version',
//                        'clients_counts' => 'Number of clients',
//                        'reservations_sum' => 'Number of reservations',
//                        'site_visits_count' => 'Total site visits',
//                        'max_room_person_count' => 'The maximum number of people in the rooms',
//                        'tax_number' => 'Tax number',
//                        'added_value' => 'Added Value',
                    ],
                ],

            ]
        ]); // Settings **


        /**
         *

         *         Module::create(['name' => 'News letters', 'path' => 'newsletters', 'meta' =>
        [
        'module_name' => ['ar' => 'الرسائل الإخبارية', 'en' => 'News letters'],
        'fields' => [
        'ar' => [
        'new' => 'قائمة البريد',
        'email' => 'إرسال إلى',
        'subject' => 'موضوع الرسالة الإخبارية',
        'message' => 'محتوى الرسالة',
        'categories' => 'الأقسام',
        ],
        'en' => [
        'new' => 'Mail list',
        'email' => 'Send to',
        'subject' => 'Subject of Newsletters',
        'message' => 'Message of Newsletters',
        'categories' => 'Select Categories',
        ],
        ],

        ]
        ]); // News letters

         *
         * Module::create(['name' => 'Galleries Categories', 'path' => 'categories', 'meta' =>
        [
        'module_name' => ['ar' => 'تصنيفات المعرض', 'en' => 'Galleries Categories'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة تصنيف جديد',
        'edit' => 'تعديل تصنيف',
        'name' => 'الإسم',
        'type' => 'نوع التصنيف',
        ],
        'en' => [
        'new' => 'Add New Category',
        'edit' => 'Edit Category',
        'name' => 'The Name',
        'type' => 'Category type',
        ],
        ]

        ]
        ]); // Galleries categories
        Module::create(['name' => 'Galleries', 'path' => 'galleries', 'meta' =>
        [
        'module_name' => ['ar' => 'المعرض', 'en' => 'Galleries'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة معرض جديدة',
        'edit' => 'تعديل معرض',
        'type' => 'نوع المعرض',
        'category_id' => 'تصنيف المعرض',
        'title' => 'عنوان الفيديو',
        'image' => 'الصورة',
        'video_url' => 'رابط الفيديو (يوتيوب)',
        ],
        'en' => [
        'new' => 'Add new gallery',
        'edit' => 'Edit gallery',
        'type' => 'Gallery type',
        'category_id' => 'Gallery category',
        'title' => 'Video title',
        'image' => 'Image',
        'video_url' => 'Video url (Youtube)',

        ],
        ],
        ]
        ]); // Galleries
        Module::create(['name' => 'Slider', 'path' => 'sliders', 'meta' =>
        [
        'module_name' => ['ar' => 'السلايدر', 'en' => 'Slider'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة سلايد جديدة',
        'edit' => 'تعديل سلايد',
        'title' => 'عنوان الاسلايد',
        //                        'url' => 'رابط الاسلايد',
        //                        'main_category_id' => 'التصنيف الرئيسي',
        //                        'sub_category_id' => 'التصنيف الفرعي',
        //                        'status' => 'الحالة',
        'description' => 'الوصف',
        //                        'image' => 'الصورة',
        ],
        'en' => [
        'new' => 'Add new slider',
        'edit' => 'Edit slider',
        'title' => 'Slide title',
        //                        'url' => 'Slider url',
        //                        'main_category_id' => 'Main category',
        //                        'sub_category_id' => 'Sub category',
        //                        'status' => 'Status',
        'description' => 'Description',
        //                        'image' => 'Image',

        ],
        ],
        ]
        ]); // Sliders

        Module::create(['name' => 'Room types', 'path' => 'roomTypes', 'meta' =>
        [
        'module_name' => ['ar' => 'أنواع الغرف', 'en' => 'Room types'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة نوع جديد',
        'edit' => 'تعديل نوع',
        'name' => 'إسم النوع',
        'branch_id' => 'إسم الفرع',
        'image' => 'الصورة',

        ],
        'en' => [
        'new' => 'Add New type',
        'edit' => 'Edit type',
        'name' => 'Type name',
        'branch_id' => 'Branch name',
        'image' => 'Image',
        ],
        ],

        ]
        ]); // Rooms types
        Module::create(['name' => 'Room services', 'path' => 'roomServices', 'meta' =>
        [
        'module_name' => ['ar' => 'خدمات الغرف', 'en' => 'Room services'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة خدمة جديد',
        'edit' => 'تعديل خدمة',
        'name' => 'إسم الخدمة',
        'image' => 'الصورة',

        ],
        'en' => [
        'new' => 'Add New service',
        'edit' => 'Edit service',
        'name' => 'Service name',
        'image' => 'Image',
        ],
        ],

        ]
        ]); // Rooms Services
        Module::create(['name' => 'Rooms', 'path' => 'rooms', 'meta' =>
        [
        'module_name' => ['ar' => 'الغرف', 'en' => 'Rooms'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة غرفة جديد',
        'edit' => 'تعديل غرفة',
        'name' => 'إسم الغرفة',
        'description' => 'تفاصيل الغرفة',
        'person_count' => 'عدد الأفراد',
        'room_price' => 'سعر الغرفة',
        'phone' => 'رقم التواصل',
        'email' => 'البريد الإلكتروني للتواصل',
        'room_status' => 'حالة الغرفة',
        'room_services_ids' => 'خدمات الغرفة',
        'video_url' => 'رابط الفيديو',
        'slider_image' => 'صورة الاسلايدر',
        'branch_id' => 'إسم الفرع',
        'room_type_id' => 'نوع الغرفة',
        'image' => 'صورة الغرفة',
        'map' => 'رابط الخريطة',

        ],
        'en' => [
        'new' => 'Add New room',
        'edit' => 'Edit room',
        'name' => 'Room name',
        'description' => 'Room details',
        'person_count' => 'Person count',
        'room_price' => 'Room price',
        'phone' => 'Contact number',
        'email' => 'Contact email',
        'room_status' => 'Room status',
        'room_services_ids' => 'Room services',
        'video_url' => 'Video link',
        'slider_image' => 'Slider image',
        'branch_id' => 'Branch name',
        'room_type_id' => 'Room type',
        'image' => 'Room image',
        'map' => 'Map link',
        ],
        ],

        ]
        ]); // Rooms

        Module::create(['name' => 'Rooms evaluates', 'path' => 'roomEvaluates', 'meta' =>
        [
        'module_name' => ['ar' => 'تقييمات الغرف', 'en' => 'Rooms evaluates'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة تقييم جديد',
        'edit' => 'تفاصيل التقييم',
        'name' => 'إسم صاحب التقييم',
        'reception_evaluation' => 'تقييم الإستقبال',
        'safety_evaluation' => 'تقييم الأمن والأمان',
        'room_evaluation' => 'تقييم الغرفة',
        'food_evaluation' => 'تقييم المأكولات والمشروبات',
        'evaluate_text' => 'نص التقييم',
        'status' => 'تفعيل وعدم تفعيل التقيم',
        'show_avg_text' => 'عرض التقييم في الرئيسية',
        'room_id' => 'إسم الغرفة',
        'branch_id' => 'إسم الفرع',

        ],
        'en' => [
        'new' => 'Add a new evaluation',
        'edit' => 'Evaluation details',
        'name' => 'The name of the reviewer',
        'reception_evaluation' => 'Reception evaluation',
        'safety_evaluation' => 'Security and safety evaluation',
        'room_evaluation' => 'Room evaluate',
        'food_evaluation' => 'Food and beverage evaluation',
        'evaluate_text' => 'Evaluation text',
        'status' => 'Activating and deactivating the evaluation',
        'show_avg_text' => 'Show evaluation in home page',
        'room_id' => 'Room name',
        'branch_id' => 'Branch name',
        ],
        ],

        ]
        ]); // Rooms Evaluates
        Module::create(['name' => 'Rooms complaints', 'path' => 'roomComplaints', 'meta' =>
        [
        'module_name' => ['ar' => 'شكاوى الغرف', 'en' => 'Rooms complaints'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة شكوى جديدة',
        'edit' => 'تفاصيل الشكوى',
        'name' => 'إسم المستخدم',
        'email' => 'البريد الإلكتروني',
        'phone' => 'رقم الجوال',
        'title' => 'عنوان الشكوى',
        'details' => 'تفاصيل الشكوى',
        'room_id' => 'إسم الغرفة',
        'branch_id' => 'إسم الفرع',
        'room_type_id' => 'نوع الغرفة',
        'image' => 'الصورة',

        ],
        'en' => [
        'new' => 'Add new complaint',
        'edit' => 'Complaint details',
        'name' => 'User name',
        'email' => 'E-mail',
        'phone' => 'Phone',
        'title' => 'Complaint title',
        'details' => 'Complaint details',
        'room_id' => 'Room name',
        'branch_id' => 'Branch name',
        'room_type_id' => 'Room type',
        'image' => 'Image',
        ],
        ],

        ]
        ]); // Rooms complaints
        Module::create(['name' => 'Partners', 'path' => 'partners', 'meta' =>
        [
        'module_name' => ['ar' => 'شركاء النجاح', 'en' => 'Partners'],
        'fields' => [
        'ar' => [
        'new' => 'إضافة شريك جديد',
        'edit' => 'تعديل شريك',
        'name' => 'الإسم',
        'type' => 'النوع',
        'image' => 'الصورة',
        'url' => 'الرابط',
        //                        'title' => 'العنوان',
        //                        'description' => 'الوصف',
        ],
        'en' => [
        'new' => 'Add New partner',
        'edit' => 'Edit partner',
        'name' => 'Name',
        'type' => 'Type',
        'image' => 'Image',
        'url' => 'url',
        //                        'title' => 'Title',
        //                        'description' => 'Description',
        ],
        ],

        ]
        ]); // Partners
         *
        Module::create(['name' => 'Directors', 'path' => 'directors', 'meta' =>
            [
                'module_name' => ['ar' => 'أعضاء مجلس الإدارة', 'en' => 'Directors'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مدير جديد',
                        'edit' => 'تعديل مدير',
                        'name' => 'الإسم الكامل',
                        'specialist' => 'التخصص',
                        'description' => 'الوصف',
                        'image' => 'الصورة',

                    ],
                    'en' => [
                        'new' => 'Add New director',
                        'edit' => 'Edit director',
                        'name' => 'Name',
                        'specialist' => 'Specialist',
                        'description' => 'Description',
                        'image' => 'Image',
                    ],
                ],

            ]
        ]); // Directors


        Module::create(['name' => 'Jobs', 'path' => 'careers', 'meta' =>
            [
                'module_name' => ['ar' => 'الوظائف', 'en' => 'Jobs'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة وظيفة جديد',
                        'edit' => 'تعديل وظيفة',
                        'name' => 'إسم الوظيفة',
                        'description' => 'تفاصيل الوظيفة',
                        'service_id' => 'إسم التخصص',

                    ],
                    'en' => [
                        'new' => 'Add New job',
                        'edit' => 'Edit job',
                        'name' => 'Job name',
                        'description' => 'Job description',
                        'service_id' => 'Specialty name',

                    ],
                ],

            ]
        ]); // Careers
        Module::create(['name' => 'News', 'path' => 'articles', 'meta' =>
            [
                'module_name' => ['ar' => 'الأخبار', 'en' => 'News'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة خبر جديد',
                        'edit' => 'تعديل خبر',
                        'external_link' => 'رابط خارجي',
                        'local_link' => 'ملف محلي',
                        'title' => 'عنوان الخبر',
                        'slug' => 'URL Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'meta_description' => 'الكلمات الوصفية',
                        'video_type' => 'نوع الفيديو',
                        'video_url' => 'رابط الفيديو',
                        'description' => 'الوصف',
                        'video' => 'الفيديو',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New new',
                        'edit' => 'Edit nwe',
                        'external_link' => 'External Link',
                        'local_link' => 'Local Storage',
                        'title' => 'New title',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                        'video_type' => 'Video Type',
                        'video_url' => 'Url',
                        'description' => 'Description',
                        'video' => 'Video',
                        'image' => 'Image',
                    ],
                ]
            ]
        ]); // Articles
        Module::create(['name' => 'Work hours', 'path' => 'workHours', 'meta' =>
            [
                'module_name' => ['ar' => 'مواعيد العمل', 'en' => 'Work hours'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة ميعاد جديد',
                        'edit' => 'تعديل ميعاد',
                        'status' => 'الحالة',
                        'week_day' => 'اليوم',
                        'time_from' => 'الوقت من',
                        'time_to' => 'الوقت إلى',

                    ],
                    'en' => [
                        'new' => 'Add New time',
                        'edit' => 'Edit time',
                        'status' => 'Status',
                        'week_day' => 'Day of week',
                        'time_from' => 'Time from',
                        'time_to' => 'Time to',

                    ],
                ],

            ]
        ]); // Work Hours
        Module::create(['name' => 'Jobs applications', 'path' => 'careerApplications', 'meta' =>
            [
                'module_name' => ['ar' => 'تقديمات الوظائف', 'en' => 'Jobs applications'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة تقديم جديد',
                        'edit' => 'تفاصيل التقديم',
                        'name' => 'الإسم الكامل',
                        'career_id' => 'إسم الوظيفة المقدم عليها',
                        'submission_date' => 'تاريخ التقديم',
                        'phone' => 'الجوال',
                        'birth_date' => 'تاريخ الميلاد',
                        'nationality' => 'الجنسية',
                        'current_residence' => 'مكان الإقامة الحالي',
                        'education' => 'المؤهل الدراسي',
                        'specialization' => 'التخصص',
                        'cv' => 'السيرة الذاتية',

                    ],
                    'en' => [
                        'new' => 'Add New job',
                        'edit' => 'Job details',
                        'name' => 'Full name',
                        'career_id' => 'Name of the position applied for',
                        'submission_date' => 'Submission date',
                        'phone' => 'Phone',
                        'birth_date' => 'Birth date',
                        'nationality' => 'Nationality',
                        'current_residence' => 'Current place of residence',
                        'education' => 'Educational Qualification',
                        'specialization' => 'Specialization',
                        'cv' => 'CV',

                    ],
                ],

            ]
        ]); // Careers Applications
         * */
    }
}
