<?php

use Illuminate\Database\Seeder;

class CareerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/content_1.jpg',
            'assets/web/images/content_2.jpg',
            'assets/web/images/content_3.jpg',
            'assets/web/images/proj-1.png',
            'assets/web/images/proj-2.png',
            'assets/web/images/proj-3.png',
        ];

        foreach (\App\Category::cursor() as $category) {
            factory(\App\Career::class, 3)->create([
                'image' => 'assets/web/images/drives-2.png',
                'category_id' => $category->id
            ]);
        }

        foreach (languages() as $language) {
            foreach (\App\Career::cursor() as $career) {
                factory(\App\CareerDescription::class)->create([
                    'career_id' => $career->id,
                    'language_id' => $language->id,
                ]);
            }

        }
    }

}
