<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSliderDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('slider_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('first_title', 100);
            $table->string('second_title', 100)->nullable();
//            $table->string('button_title', 50)->nullable();
            $table->text('description');

            $table->unsignedBigInteger('slider_id');
            $table->unsignedBigInteger('language_id');

            $table->foreign('slider_id')->references('id')->on('sliders')->onDelete('cascade');

            $table->index(['slider_id', 'language_id']);
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('slider_descriptions');
    }
}
