<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitorMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visitor_messages', function (Blueprint $table) {
            $table->id();
//            $table->string('name', 100);
            $table->string('email', 100);
            $table->string('phone', 15)->nullable();
            $table->string('address', 200)->nullable();
//            $table->string('subject', 200)->nullable();
//            $table->longText('message');
            $table->boolean('read')->default('0');
            $table->boolean('reply')->default('0');

            $table->index('id');
            $table->softDeletes();
            $table->timestamps();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visitor_messages');
    }
}
