<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name', 300)->nullable();
            $table->string('email', 250)->nullable();
            $table->string('phone', 14)->nullable();
            $table->string('photo', 300)->nullable();
            $table->enum('lang', ['ar', 'en'])->nullable();
            $table->string('admin_token', 100)->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password', 100)->nullable();
            $table->enum('role',['super_admin','admin', 'sub_admin', 'user'])->default('sub_admin');

            $table->json('device_info')->nullable();
            $table->string('api_token', 50)->nullable();

            $table->char('verify_code', 4)->nullable()->comment('code for reset psw or login');
            $table->tinyInteger('attempt_send_code')->nullable()->comment('The number of times the code is sent per day');
            $table->date('last_attempt_date')->nullable()->comment('Last sent date');
            $table->tinyInteger('code_verify_attempt')->nullable()->comment('Code verification attempts');

            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
