<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\CareerDescription;
use Faker\Generator as Faker;

$factory->define(CareerDescription::class, function (Faker $faker) {
    return [
        'name' => 'Job Title',
        'career_description' => '<ul>
                                                    <li>
                                                        Provide infrastructure support for enterprise applications, data warehouses, and in-house developed applications
                                                    </li>
                                                    <li>
                                                        Perform maintenance operations daily, weekly or monthly on MySQL/PostgreSQL/Oracle databases and information systems to ensure efficient program operations
                                                    </li>
                                                    <li>
                                                       Prepare and perform production cutover plans to support development, test and production environments. Responsible for propagating production changes.
                                                    </li>
                                                    <li>
                                                        Develop overall integration tests to ensure code does not adversely affect existing programs
                                                    </li>
                                                    <li>
                                                        Document database environments and help define and document processes and procedures
                                                    </li>
                                                    <li>
                                                       Monitor systems and platforms for security, performance and availability
                                                    </li>
                                                    <li>
                                                        Performance troubleshooting, tuning, indexing and query changes
                                                    </li>
                                                    <li>
                                                        Deploy database change scripts provided by third-party vendors
                                                    </li>
                                                    <li>
                                                        Recommend, deploy and utilize tools to manage the DB systems
                                                    </li>
                                                    <li>
                                                        Provide timely responses to emails, phone calls, IMs, SMS messages, and other general communication from peers, users and management
                                                    </li>
                                                    <li>
                                                        Perform other duties as required
                                                    </li>
                                                    <li>
                                                        Special assignments as business dictates
                                                    </li>
                                                    <li>
                                                        On-call rotation and participation in special event coverage is required.
                                                    </li>
                                                </ul>',
        'mini_qualifications' => '<ul>
                                                    <li>
                                                         Bachelor’s degree in computer science or related field
                                                    </li>
                                                    <li>
                                                         5+ years of DBA experience
                                                    </li>
                                                    <li>
                                                         Experience managing different databases. Proficiency in database administration, management, data imports and exports, and developing reports
                                                    </li>
                                                    <li>
                                                         SQL Admin function experience (backup/restore, shrink logs, replication, encryption, overall architecture)
                                                    </li>
                                                    <li>
                                                         Experience with DB Performance Tuning/Benchmarking/Trending
                                                    </li>
                                                    <li>
                                                         In-depth understanding of data management (e.g. permissions, recovery, security and monitoring)
                                                    </li>
                                                    <li>
                                                         Advanced knowledge of database structure, software development and user interface web applications
                                                    </li>
                                                    <li>
                                                         Strong transact SQL skills, SSIS/SSRS and shell scripting technologies
                                                    </li>
                                                    <li>
                                                         Involve in designing, deployment, and management of the DR Site.
                                                    </li>
                                                    <li>
                                                         Well experienced in VMware Environments and its security.
                                                    </li>
                                                    <li>
                                                        Familiarity working with .Net Framework, JavaScript, HTML and Oracle
                                                    </li>
                                                    <li>
                                                        Ability to communicate effectively with business users, team members and management and identity needs, define processes, and evaluate technical solutions and strategies
                                                    </li>
                                                    <li>
                                                        Experience troubleshooting in a production environment
                                                    </li>
                                                    <li>
                                                        Ability to work independently with minimal supervision and assistance
                                                    </li>
                                                </ul>'
    ];
});
