<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendBillMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    public $view;

    /**
     * Create a new message instance.
     *
     * @param $data
     * @param $view
     */
    public function __construct($data, $view)
    {
        $this->data = $data;
        $this->view = $view;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('web.rooms.emails.send_bill')->subject(__('roomReservations.bill_details'));
    }
}
