<?php

namespace App\Jobs;

use App\Mail\VisitorMessagesMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class VisitorMessagesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $data;
    private $view;
    private $to;

    /**
     * Create a new job instance.
     * @param $data
     * @param $view
     */
    public function __construct($data, $view)
    {
        $this->data = $data;
        $this->view = $view;
        $this->to = $data['to'] ?? settings('site_email');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $visitorMessage = new VisitorMessagesMail($this->data, $this->view);
        Mail::to($this->to)->send($visitorMessage);
    }
}
