<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed name
 * @property mixed reservation_id
 * @property mixed service_id
 * @property mixed appointment_date
 * @property mixed appointment_time
 * @property mixed rate
 * @property mixed comment
 */
class EvaluateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'name' => $this->name,
            'reservation_id' => $this->reservation_id,
            'service_id' => $this->service_id,
            'appointment_date' => $this->appointment_date,
            'appointment_time' => $this->appointment_time,
            'rate' => $this->rate,
            'comment' => $this->comment,
        ];
    }
}
