<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Http\Requests\Web\VisitorMessageRequest;
use App\Page;
use App\VisitorMessage;
use App\WorkHour;
use Illuminate\Http\JsonResponse;

class VisitorMessageController extends Controller
{

    private $view = 'web.contacts.';


    public function index()
    {

        $title = __('main.contact_us');
        $workHours = WorkHour::withDescription()->contact_us_work_time;
        return view( $this->view.'index', get_defined_vars());
    }

    public function store(VisitorMessageRequest $request) :JsonResponse
    {
        VisitorMessage::create($request->all());
        return response()->json(['message' => __('visitorMessages.message_success')]);
    }
}
