<?php

namespace App\Http\Controllers\Web;

use App\Appointment;
use App\AppointmentTime;
use App\Branch;
use App\Doctor;
use App\Evaluate;
use App\Helpers\Sms;
use App\Http\Controllers\Controller;
use App\Http\Requests\Web\AddBookingRequest;
use App\Jobs\SendBookingMessageJob;
use App\Reservation;
use App\Service;
use App\User;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Lang;
use Illuminate\Validation\ValidationException;
use Illuminate\View\View;

class TaskScheduleController extends Controller
{

    public function sendEvaluateLink()
    {
        $langId = currentLanguage()->id;
        $reminderTimeStart = Carbon::now()->addHours(-2)->format('H:i');
        $reminderTimeEnd = Carbon::now()->format('H:i');
        $reminderDate = Carbon::now()->format('Y-m-d');
        $reservations = Reservation::where('reservations.status', '=', 'confirmed')
            ->whereDate('reservations.appointment_date', $reminderDate)
            ->whereBetween('reservations.appointment_time', [$reminderTimeStart, $reminderTimeEnd])

            ->join('doctors', 'doctors.id', 'reservations.doctor_id')
            ->join('doctor_descriptions AS dDesc', 'doctors.id', 'dDesc.doctor_id')
            ->where('dDesc.language_id', $langId)

            ->select([
                'reservations.id',
                'reservations.name',
                'reservations.email',
                'reservations.phone',
                'reservations.evaluate_token',
                'dDesc.name as doctor_name',
            ])->cursor();


        foreach ($reservations as $reservation) {
            $message = __('reservations.appointment_msg_status_4');
            $name = $reservation->name;
            $doctorName = $reservation->doctor_name;
            $link = route('booking.evaluate', [$reservation->id, $reservation->evaluate_token]);
//            $link = request()->root().'/foot/booking/evaluate/'.$reservation->id.'/'.$reservation->evaluate_token;
            $message = str_replace_array('@@', [$name, $doctorName, $link], $message);

//            try{
//                Sms::send($reservation->phone, $message);
//            } catch (Exception $exception){
//                return ['errors' => __('members.sms_error')];
//            }

            try{
                $data = [
                    'subject' => __('reservations.reservation_evaluate_msg'),
                    'message' => $message,
                    'email' => $reservation->email
                ];
                SendBookingMessageJob::dispatch($data, 'web.bookings.emails.send_email');

            } catch (\Exception $e){}
        }
    }


}
