<?php

namespace App\Http\Controllers\Web;

use App\Branch;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;

class BranchController extends Controller
{

    private $view = 'web.branches.';

    /**
     * Show the application dashboard.
     * @param Request $request
     * @return View
     */
    public function index(Request $request): View
    {
        $title = __('branches.head');
        $branches = Branch::withDescription([], $request->branch_name);
        session()->flash('branch_name', $request->branch_name);
        return view($this->view.'index', get_defined_vars());
    }

}
