<?php

namespace App\Http\Controllers\Admin;

use App\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
//Check the request is valid
use App\Http\Requests\LoginRequest;
use App\Http\Controllers\Controller;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Auth;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Session;
use Illuminate\View\View;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your Admin screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    // use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::ADMIN;
    protected $redirectRoute = '/admin/login';
    protected $dashboard = '/admin';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->redirectRoute = getCurrentLocale() . $this->redirectRoute;
        $this->dashboard = getCurrentLocale() . $this->dashboard;
    }

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index()
    {
        $title = strtoupper(__('dashboard.login'));
        if (Auth::check() && Auth::user()->admin_token){
            return redirect($this->dashboard);
        }

        if (Auth::check()){
            return redirect($this->dashboard);
        }

        return view('admin.login', get_defined_vars());
    }

    /**
     * Function for Admin login to the cms
     * @param LoginRequest $request
     * @return RedirectResponse|Redirector
     */
    public function authenticate(LoginRequest $request) :RedirectResponse
    {
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials, $request->remember)) {

            /**
             * Check if the dashboard is disabled
             * for other administrators, other than the super admin
             */

            if (Auth::user()->role != 'super_admin'){
                if (settings('dashboard_disable') == 1){
                    Auth::logout();
                    return redirect($this->redirectRoute)->with('error', __('dashboard.failed'));
                }
            }

            // Authentication passed...
            return redirect($this->dashboard);
        }

        return redirect($this->redirectRoute)->withInput()->with('error', __('auth.failed'));
    }


    /**
     * Admin logout
     * @return RedirectResponse|Redirector
     */
    public function logout() :RedirectResponse
    {
        Session::flush();
        Auth::logout();
        return redirect($this->redirectRoute);
    }
}
