<?php

namespace App\Http\Controllers\API;

use App\AppSlider;
use App\Http\Controllers\Controller;
use App\Http\Resources\ServiceResource;
use App\Http\Resources\SliderResource;
use App\Service;
use Illuminate\Http\JsonResponse;

class ServiceController extends Controller
{

    /**
     * Get all services
     * @return JsonResponse
     */
    public function index() :JsonResponse
    {
        $services = Service::withDescription()->cursor();
        $appSlider = AppSlider::withDescription();
        $data = [
            'services' => ServiceResource::collection($services),
            'app_slider' => SliderResource::collection($appSlider),
        ];
        return response()->json(['message' => '', 'data' => $data], 200);
    }

    public function show($id)
    {
        $service = Service::withDescription([$id])->first();
        $data = ServiceResource::make($service);
        return response()->json(['message' => '', 'data' => $data], 200);
    }

}
