<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Category
 * @package App
 * @mixin Builder
 */
class Category extends Model
{
    // For soft delete
    use SoftDeletes;

    protected $fillable = ['type', 'status'];

    /**
     * Get the description of the category.
     * @param int $language_id
     * @return HasMany
     */
    public function descriptions($language_id= 0) :HasMany
    {
        if ($language_id) {
            return $this->hasMany(CategoryDescription::class)->where('language_id', $language_id);
        }
        return $this->hasMany(CategoryDescription::class);
    }


    public static function withDescription($type = null, $limit = null)
    {
        $category = self::join('category_descriptions as sd', 'sd.category_id', 'categories.id')
            ->where('sd.language_id', currentLanguage()->id);

        if($type) {
            $category->whereType($type);
        }

        if ($limit){
            $category->limit($limit);
        }

        return $category->select(['sd.name', 'categories.*'])->cursor() ?? [];
    }

}
