<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed service_id
 * @mixin Builder
 */
class Career extends Model
{
    use SoftDeletes;

    protected $fillable = ['image', 'category_id'];


    public function careerApplications()
    {
        return $this->hasMany(CareerApplication::class);
    }

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(CareerDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(CareerDescription::class)->where('language_id', currentLanguage()->id);
    }


    public static function withDescription()
    {
        $langId = currentLanguage()->id;
        $query = self::orderByDesc('careers.id')->join('career_descriptions as cDesc', 'cDesc.career_id', 'careers.id')
            ->where('cDesc.language_id', $langId)
//            ->join('services', 'careers.service_id', 'services.id')
//            ->join('service_descriptions as sDesc', 'sDesc.service_id', 'services.id')
//            ->where('sDesc.language_id', $langId)
            ->select([
                'careers.id',
                'careers.created_at',
                'careers.service_id',
                'careers.image',
                'cDesc.name',
                'cDesc.description',
//                'sDesc.name as service_name'
            ]);

        return $query->get();
    }


}
